/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.graphics.FontFamily;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.FontFamilyNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowFontFamily;
import org.robolectric.shadows.ShadowNativeFont;

@Implements(value=FontFamily.class, minSdk=26, isInAndroidSdk=false, shadowPicker=Picker.class, callNativeMethodsByDefault=true)
public class ShadowNativeFontFamily {
    @Implementation(minSdk=35)
    protected static void __staticInitializer__() {
    }

    @Implementation(minSdk=26, maxSdk=34)
    public static long nInitBuilder(String langs, int variant) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return FontFamilyNatives.nInitBuilder((String)langs, (int)variant);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nAllowUnsupportedFont(long builderPtr) {
        FontFamilyNatives.nAllowUnsupportedFont((long)builderPtr);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static long nCreateFamily(long mBuilderPtr) {
        return FontFamilyNatives.nCreateFamily((long)mBuilderPtr);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static long nGetBuilderReleaseFunc() {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return FontFamilyNatives.nGetBuilderReleaseFunc();
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static long nGetFamilyReleaseFunc() {
        return FontFamilyNatives.nGetFamilyReleaseFunc();
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nAddFont(long builderPtr, ByteBuffer font, int ttcIndex, int weight, int isItalic) {
        return FontFamilyNatives.nAddFont((long)builderPtr, (ByteBuffer)font, (int)ttcIndex, (int)weight, (int)isItalic);
    }

    @Implementation(minSdk=26, maxSdk=29)
    protected static boolean nAddFontFromAssetManager(long builderPtr, AssetManager mgr, String path, int cookie, boolean isAsset, int ttcIndex, int weight, int isItalic) {
        try {
            ByteBuffer byteBuffer = ShadowNativeFont.assetToBuffer(mgr, path, isAsset, cookie);
            return ShadowNativeFontFamily.nAddFont(builderPtr, byteBuffer, ttcIndex, weight, isItalic);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nAddFontWeightStyle(long builderPtr, ByteBuffer font, int ttcIndex, int weight, int isItalic) {
        return FontFamilyNatives.nAddFontWeightStyle((long)builderPtr, (ByteBuffer)font, (int)ttcIndex, (int)weight, (int)isItalic);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nAddAxisValue(long builderPtr, int tag, float value) {
        FontFamilyNatives.nAddAxisValue((long)builderPtr, (int)tag, (float)value);
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static void nAbort(long mBuilderPtr) {
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowFontFamily.class, ShadowNativeFontFamily.class);
        }
    }
}

