/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SystemProperties;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import org.robolectric.RuntimeEnvironment;

final class SystemFeatureListInitializer {
    SystemFeatureListInitializer() {
    }

    public static ImmutableMap<String, Boolean> getSystemFeatures() {
        int vendorApiLevel;
        int apiLevel = RuntimeEnvironment.getApiLevel();
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("android.hardware.touchscreen", true);
        if (apiLevel >= 25) {
            features.put("android.hardware.wifi", true);
        }
        if (apiLevel >= 26) {
            features.put("android.hardware.wifi.aware", true);
            features.put("android.software.companion_device_setup", true);
        }
        if (apiLevel >= 28) {
            features.put("android.hardware.wifi.direct", true);
            features.put("android.hardware.wifi.rtt", true);
        }
        if (apiLevel >= 34) {
            features.put("android.hardware.telephony.subscription", true);
        }
        if ((vendorApiLevel = SystemProperties.getInt((String)"ro.vendor.api_level", (int)0)) >= 202404) {
            features.put("android.hardware.telephony.calling", true);
            features.put("android.hardware.telephony.messaging", true);
            features.put("android.hardware.telephony.data", true);
            features.put("android.hardware.telephony.euicc", true);
            features.put("android.hardware.telephony.euicc.mep", true);
            features.put("android.hardware.telephony.ims", true);
            if (apiLevel >= 36) {
                features.put("android.hardware.telephony.satellite", true);
            }
        }
        return ImmutableMap.copyOf(features);
    }
}

