/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityThread;
import android.app.UiAutomation;
import android.content.ContentResolver;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.os.IBinder;
import android.os.SystemClock;
import android.provider.Settings;
import android.view.Display;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.HardwareRenderingScreenshot;
import org.robolectric.shadows.ShadowDisplay;
import org.robolectric.shadows.ShadowDisplayManager;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=UiAutomation.class)
public class ShadowUiAutomation {
    private static final Predicate<Root> IS_FOCUSABLE = ShadowUiAutomation.hasLayoutFlag(8).negate();
    private static final Predicate<Root> IS_TOUCHABLE = ShadowUiAutomation.hasLayoutFlag(16).negate();
    private static final Predicate<Root> IS_TOUCH_MODAL = IS_FOCUSABLE.and(ShadowUiAutomation.hasLayoutFlag(32).negate());
    private static final Predicate<Root> WATCH_TOUCH_OUTSIDE = IS_TOUCH_MODAL.negate().and(ShadowUiAutomation.hasLayoutFlag(262144));

    public static void setAnimationScaleCompat(float scale) {
        ContentResolver cr = RuntimeEnvironment.getApplication().getContentResolver();
        Settings.Global.putFloat((ContentResolver)cr, (String)"animator_duration_scale", (float)scale);
        Settings.Global.putFloat((ContentResolver)cr, (String)"transition_animation_scale", (float)scale);
        Settings.Global.putFloat((ContentResolver)cr, (String)"window_animation_scale", (float)scale);
    }

    @Implementation(minSdk=28)
    protected void grantRuntimePermission(String packageName, String permission2) {
        ShadowUiAutomation.getShadowInstrumentation().grantPermissions(permission2);
    }

    static ShadowInstrumentation getShadowInstrumentation() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        return (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
    }

    @Implementation(minSdk=33)
    protected void setAnimationScale(float scale) {
        ShadowUiAutomation.setAnimationScaleCompat(scale);
    }

    @Implementation
    protected boolean setRotation(int rotation) {
        AtomicBoolean result = new AtomicBoolean(false);
        ShadowInstrumentation.runOnMainSyncNoIdle(() -> {
            if (rotation == -1 || rotation == -2) {
                result.set(true);
                return;
            }
            Display display = ShadowDisplay.getDefaultDisplay();
            int currentRotation = display.getRotation();
            boolean isRotated = (rotation == 0 || rotation == 2) != (currentRotation == 0 || currentRotation == 2);
            Shadows.shadowOf(display).setRotation(rotation);
            if (isRotated) {
                int currentOrientation = Resources.getSystem().getConfiguration().orientation;
                String rotationQualifier = "+" + (currentOrientation == 1 ? "land" : "port");
                ShadowDisplayManager.changeDisplay(display.getDisplayId(), rotationQualifier);
                RuntimeEnvironment.setQualifiers(rotationQualifier);
            }
            result.set(true);
        });
        return result.get();
    }

    @Implementation
    protected void throwIfNotConnectedLocked() {
    }

    @Implementation
    protected Bitmap takeScreenshot() throws Exception {
        if (!ShadowView.useRealGraphics()) {
            return null;
        }
        FutureTask<Bitmap> screenshotTask = new FutureTask<Bitmap>(() -> {
            Point displaySize = new Point();
            ShadowDisplay.getDefaultDisplay().getRealSize(displaySize);
            Bitmap screenshot = Bitmap.createBitmap((int)displaySize.x, (int)displaySize.y, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas screenshotCanvas = new Canvas(screenshot);
            Paint paint = new Paint();
            long drawingTime = SystemClock.uptimeMillis();
            for (Root root : ShadowUiAutomation.getViewRoots().reverse()) {
                View rootView = root.getRootView();
                if (ShadowView.useRealViewAnimations()) {
                    ((ShadowView)Shadow.extract((Object)rootView)).setDrawingTime(drawingTime);
                }
                if (rootView.getWidth() <= 0 || rootView.getHeight() <= 0) continue;
                Bitmap window = Bitmap.createBitmap((int)rootView.getWidth(), (int)rootView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (HardwareRenderingScreenshot.canTakeScreenshot(rootView)) {
                    HardwareRenderingScreenshot.takeScreenshot(rootView, window);
                } else {
                    Canvas windowCanvas = new Canvas(window);
                    rootView.draw(windowCanvas);
                }
                screenshotCanvas.drawBitmap(window, (float)root.locationOnScreen.x, (float)root.locationOnScreen.y, paint);
            }
            return screenshot;
        });
        ShadowInstrumentation.runOnMainSyncNoIdle(screenshotTask);
        return screenshotTask.get();
    }

    public static boolean injectInputEvent(InputEvent event) {
        AtomicBoolean result = new AtomicBoolean(false);
        ShadowInstrumentation.runOnMainSyncNoIdle(() -> {
            if (event instanceof MotionEvent) {
                result.set(ShadowUiAutomation.injectMotionEvent((MotionEvent)event));
            } else if (event instanceof KeyEvent) {
                result.set(ShadowUiAutomation.injectKeyEvent((KeyEvent)event));
            } else {
                throw new IllegalArgumentException("Unrecognized event type: " + event);
            }
        });
        return result.get();
    }

    @Implementation
    protected boolean injectInputEvent(InputEvent event, boolean sync) {
        return ShadowUiAutomation.injectInputEvent(event);
    }

    private static boolean injectMotionEvent(MotionEvent event) {
        List touchableRoots = ShadowUiAutomation.getViewRoots().stream().filter(IS_TOUCHABLE).collect(Collectors.toList());
        for (int i = 0; i < touchableRoots.size(); ++i) {
            Root root = (Root)touchableRoots.get(i);
            if (i == touchableRoots.size() - 1 || root.isTouchModal() || root.isTouchInside(event)) {
                event.offsetLocation((float)(-root.locationOnScreen.x), (float)(-root.locationOnScreen.y));
                if (ShadowUiAutomation.shouldDispatchGenericMotionEvent(event)) {
                    root.getRootView().dispatchGenericMotionEvent(event);
                } else {
                    root.getRootView().dispatchTouchEvent(event);
                }
                event.offsetLocation((float)root.locationOnScreen.x, (float)root.locationOnScreen.y);
                break;
            }
            if (event.getActionMasked() != 0 || !root.watchTouchOutside()) continue;
            MotionEvent outsideEvent = MotionEvent.obtain((MotionEvent)event);
            outsideEvent.setAction(4);
            outsideEvent.offsetLocation((float)(-root.locationOnScreen.x), (float)(-root.locationOnScreen.y));
            if (ShadowUiAutomation.shouldDispatchGenericMotionEvent(outsideEvent)) {
                root.getRootView().dispatchGenericMotionEvent(outsideEvent);
            } else {
                root.getRootView().dispatchTouchEvent(outsideEvent);
            }
            outsideEvent.recycle();
        }
        return true;
    }

    private static boolean shouldDispatchGenericMotionEvent(MotionEvent event) {
        return event.isFromSource(8194) && event.getActionMasked() == 8;
    }

    private static boolean injectKeyEvent(KeyEvent event) {
        ShadowUiAutomation.getViewRoots().stream().filter(IS_FOCUSABLE).findFirst().ifPresent(root -> root.getRootView().dispatchKeyEvent(event));
        return true;
    }

    private static ImmutableList<Root> getViewRoots() {
        List<ViewRootImpl> viewRootImpls = ShadowUiAutomation.getViewRootImpls();
        List<WindowManager.LayoutParams> params = ShadowUiAutomation.getRootLayoutParams();
        Preconditions.checkState((params.size() == viewRootImpls.size() ? 1 : 0) != 0, (Object)"number params is not consistent with number of view roots!");
        Set<IBinder> startedActivityTokens = ShadowUiAutomation.getStartedActivityTokens();
        ArrayList<Root> roots = new ArrayList<Root>();
        for (int i = 0; i < viewRootImpls.size(); ++i) {
            Root root = new Root(viewRootImpls.get(i), params.get(i), i);
            if (root.getType() == 1 && !startedActivityTokens.contains(root.impl.getView().getApplicationWindowToken())) continue;
            roots.add(root);
        }
        roots.sort(Comparator.comparingInt(Root::getType).reversed().thenComparing(Comparator.comparingInt(Root::getIndex).reversed()));
        return ImmutableList.copyOf(roots);
    }

    private static List<ViewRootImpl> getViewRootImpls() {
        Object windowManager = ShadowUiAutomation.getViewRootsContainer();
        Object viewRootsObj = ReflectionHelpers.getField((Object)windowManager, (String)"mRoots");
        Class<?> viewRootsClass = viewRootsObj.getClass();
        if (ViewRootImpl[].class.isAssignableFrom(viewRootsClass)) {
            return Arrays.asList((ViewRootImpl[])viewRootsObj);
        }
        if (List.class.isAssignableFrom(viewRootsClass)) {
            return (List)viewRootsObj;
        }
        throw new IllegalStateException("WindowManager.mRoots is an unknown type " + viewRootsClass.getName());
    }

    private static List<WindowManager.LayoutParams> getRootLayoutParams() {
        Object windowManager = ShadowUiAutomation.getViewRootsContainer();
        Object paramsObj = ReflectionHelpers.getField((Object)windowManager, (String)"mParams");
        Class<?> paramsClass = paramsObj.getClass();
        if (WindowManager.LayoutParams[].class.isAssignableFrom(paramsClass)) {
            return Arrays.asList((WindowManager.LayoutParams[])paramsObj);
        }
        if (List.class.isAssignableFrom(paramsClass)) {
            return (List)paramsObj;
        }
        throw new IllegalStateException("WindowManager.mParams is an unknown type " + paramsClass.getName());
    }

    private static Object getViewRootsContainer() {
        return WindowManagerGlobal.getInstance();
    }

    private static Set<IBinder> getStartedActivityTokens() {
        Set startedActivities = Sets.newConcurrentHashSet();
        ShadowInstrumentation.runOnMainSyncNoIdle(() -> {
            ActivityLifecycleMonitor monitor = ActivityLifecycleMonitorRegistry.getInstance();
            startedActivities.addAll(monitor.getActivitiesInStage(Stage.STARTED));
            startedActivities.addAll(monitor.getActivitiesInStage(Stage.RESUMED));
        });
        return startedActivities.stream().map(activity -> activity.getWindow().getDecorView().getApplicationWindowToken()).collect(Collectors.toSet());
    }

    private static Predicate<Root> hasLayoutFlag(int flag) {
        return root -> (root.params.flags & flag) == flag;
    }

    private static final class Root {
        final ViewRootImpl impl;
        final WindowManager.LayoutParams params;
        final int index;
        final Point locationOnScreen;

        Root(ViewRootImpl impl, WindowManager.LayoutParams params, int index) {
            this.impl = impl;
            this.params = params;
            this.index = index;
            int[] coords = new int[2];
            this.getRootView().getLocationOnScreen(coords);
            this.locationOnScreen = new Point(coords[0], coords[1]);
        }

        int getIndex() {
            return this.index;
        }

        int getType() {
            return this.params.type;
        }

        View getRootView() {
            return this.impl.getView();
        }

        boolean isTouchInside(MotionEvent event) {
            int index = event.getActionIndex();
            return event.getX(index) >= (float)this.locationOnScreen.x && event.getX(index) <= (float)(this.locationOnScreen.x + this.impl.getView().getWidth()) && event.getY(index) >= (float)this.locationOnScreen.y && event.getY(index) <= (float)(this.locationOnScreen.y + this.impl.getView().getHeight());
        }

        boolean isTouchModal() {
            return IS_TOUCH_MODAL.test(this);
        }

        boolean watchTouchOutside() {
            return WATCH_TOUCH_OUTSIDE.test(this);
        }
    }
}

