/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Intent;
import android.service.quicksettings.Tile;
import android.service.quicksettings.TileService;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;

@Implements(value=TileService.class, minSdk=24)
public class ShadowTileService {
    private Tile tile;
    private boolean isLocked = false;
    @RealObject
    private TileService realObject;

    @Implementation
    protected final Tile getQsTile() {
        if (this.tile == null) {
            this.tile = ShadowTileService.createTile();
        }
        return this.tile;
    }

    @Implementation
    protected final void unlockAndRun(Runnable runnable) {
        this.setLocked(false);
        if (runnable != null) {
            runnable.run();
        }
    }

    @Implementation
    protected void startActivityAndCollapse(Intent intent) {
        this.realObject.startActivity(intent);
    }

    @Implementation
    protected boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    private static Tile createTile() {
        return (Tile)Shadow.newInstanceOf(Tile.class);
    }
}

