/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.StatusBarManager;
import com.android.internal.annotations.VisibleForTesting;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=StatusBarManager.class, isInAndroidSdk=false)
public class ShadowStatusBarManager {
    public static final int DEFAULT_DISABLE_MASK = 0x7FF0000;
    public static final int DEFAULT_DISABLE2_MASK = 31;
    public static final int DISABLE_NOTIFICATION_ALERTS = 262144;
    public static final int DISABLE_EXPAND = 65536;
    public static final int DISABLE_HOME = 0x200000;
    public static final int DISABLE_CLOCK = 0x800000;
    public static final int DISABLE_RECENT = 0x1000000;
    public static final int DISABLE_SEARCH = 0x2000000;
    public static final int DISABLE_NONE = 0;
    public static final int DISABLE2_ROTATE_SUGGESTIONS = 16;
    public static final int DISABLE2_NONE = 0;
    private static int disabled = 0;
    private static int disabled2 = 0;
    private static int navBarMode = 0;

    @Implementation
    protected void disable(int what) {
        disabled = what;
    }

    @Implementation(minSdk=23)
    protected void disable2(int what) {
        disabled2 = what;
    }

    @Implementation(minSdk=29)
    protected void setDisabledForSetup(boolean disabled) {
        this.disable(disabled ? ShadowStatusBarManager.getDefaultSetupDisableFlags() : 0);
        this.disable2(disabled ? ShadowStatusBarManager.getDefaultSetupDisable2Flags() : 0);
    }

    @VisibleForTesting
    static int getDefaultSetupDisableFlags() {
        return ((StatusBarManagerReflector)Reflector.reflector(StatusBarManagerReflector.class)).getDefaultSetupDisableFlags();
    }

    @VisibleForTesting
    static int getDefaultSetupDisable2Flags() {
        return ((StatusBarManagerReflector)Reflector.reflector(StatusBarManagerReflector.class)).getDefaultSetupDisable2Flags();
    }

    public int getDisableFlags() {
        return disabled;
    }

    public int getDisable2Flags() {
        return disabled2;
    }

    @Implementation(minSdk=33)
    protected void setNavBarMode(int mode) {
        navBarMode = mode;
    }

    @Implementation(minSdk=33)
    protected int getNavBarMode() {
        return navBarMode;
    }

    @Resetter
    public static void reset() {
        disabled = 0;
        disabled2 = 0;
        navBarMode = 0;
    }

    @ForType(value=StatusBarManager.class)
    static interface StatusBarManagerReflector {
        @Static
        @Accessor(value="DEFAULT_SETUP_DISABLE_FLAGS")
        public int getDefaultSetupDisableFlags();

        @Static
        @Accessor(value="DEFAULT_SETUP_DISABLE2_FLAGS")
        public int getDefaultSetupDisable2Flags();
    }
}

