/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.AutomaticZenRule;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Process;
import android.service.notification.StatusBarNotification;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowSystem;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=NotificationManager.class)
public class ShadowNotificationManager {
    private static final int MAX_NOTIFICATION_LIMIT = 25;
    private static boolean mAreNotificationsEnabled = true;
    private static boolean isNotificationPolicyAccessGranted = false;
    private static boolean enforceMaxNotificationLimit = false;
    private static final Map<Key, PostedNotification> notifications = new ConcurrentHashMap<Key, PostedNotification>();
    private static final Map<String, NotificationChannel> notificationChannels = new ConcurrentHashMap<String, NotificationChannel>();
    private static final Map<String, NotificationChannelGroup> notificationChannelGroups = new ConcurrentHashMap<String, NotificationChannelGroup>();
    private static final Map<String, NotificationChannel> deletedNotificationChannels = new ConcurrentHashMap<String, NotificationChannel>();
    private static final Map<String, AutomaticZenRule> automaticZenRules = new ConcurrentHashMap<String, AutomaticZenRule>();
    private static final Map<String, Boolean> listenerAccessGrantedComponents = new ConcurrentHashMap<String, Boolean>();
    private static final Set<String> canNotifyOnBehalfPackages = Sets.newConcurrentHashSet();
    private static int currentInterruptionFilter = 1;
    private static NotificationManager.Policy notificationPolicy;
    private static NotificationManager.Policy consolidatedNotificationPolicy;
    private static String notificationDelegate;
    private static int importance;

    @Resetter
    public static void reset() {
        mAreNotificationsEnabled = true;
        isNotificationPolicyAccessGranted = false;
        enforceMaxNotificationLimit = false;
        notifications.clear();
        notificationChannels.clear();
        notificationChannelGroups.clear();
        deletedNotificationChannels.clear();
        automaticZenRules.clear();
        listenerAccessGrantedComponents.clear();
        canNotifyOnBehalfPackages.clear();
        currentInterruptionFilter = 1;
        notificationPolicy = null;
        notificationDelegate = null;
        consolidatedNotificationPolicy = null;
        importance = 0;
    }

    @Implementation
    protected void notify(int id2, Notification notification) {
        this.notify(null, id2, notification);
    }

    @Implementation
    protected void notify(String tag, int id2, Notification notification) {
        if (!enforceMaxNotificationLimit || notifications.size() < 25) {
            notifications.put(new Key(tag, id2), new PostedNotification(notification, ShadowSystem.currentTimeMillis()));
        }
    }

    @Implementation
    protected void cancel(int id2) {
        this.cancel(null, id2);
    }

    @Implementation
    protected void cancel(String tag, int id2) {
        Key key = new Key(tag, id2);
        notifications.remove(key);
    }

    @Implementation
    protected void cancelAll() {
        notifications.clear();
    }

    @Implementation(minSdk=24)
    protected boolean areNotificationsEnabled() {
        return mAreNotificationsEnabled;
    }

    public void setNotificationsEnabled(boolean areNotificationsEnabled) {
        mAreNotificationsEnabled = areNotificationsEnabled;
    }

    @Implementation(minSdk=24)
    protected int getImportance() {
        return importance;
    }

    public void setImportance(int importance) {
        ShadowNotificationManager.importance = importance;
    }

    @Implementation(minSdk=23)
    public StatusBarNotification[] getActiveNotifications() {
        ImmutableMap notifsCopy = ImmutableMap.copyOf(notifications);
        StatusBarNotification[] statusBarNotifications = new StatusBarNotification[notifsCopy.size()];
        int i = 0;
        for (Map.Entry entry : notifsCopy.entrySet()) {
            statusBarNotifications[i++] = new StatusBarNotification(RuntimeEnvironment.getApplication().getPackageName(), null, ((Key)entry.getKey()).id, ((Key)entry.getKey()).tag, Process.myUid(), Process.myPid(), 0, ((PostedNotification)entry.getValue()).notification, Process.myUserHandle(), ((PostedNotification)entry.getValue()).postedTimeMillis);
        }
        return statusBarNotifications;
    }

    @Implementation(minSdk=26)
    protected NotificationChannel getNotificationChannel(String channelId) {
        return notificationChannels.get(channelId);
    }

    @Implementation(minSdk=30)
    protected NotificationChannel getNotificationChannel(String channelId, String conversationId) {
        for (NotificationChannel notificationChannel : this.getNotificationChannels()) {
            if (!conversationId.equals(notificationChannel.getConversationId()) || !channelId.equals(notificationChannel.getParentChannelId())) continue;
            return notificationChannel;
        }
        return null;
    }

    @Implementation(minSdk=26)
    protected void createNotificationChannelGroup(NotificationChannelGroup group) {
        String id2 = (String)ReflectionHelpers.callInstanceMethod((Object)group, (String)"getId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        notificationChannelGroups.put(id2, group);
    }

    @Implementation(minSdk=26)
    protected void createNotificationChannelGroups(List<NotificationChannelGroup> groupList) {
        for (NotificationChannelGroup group : groupList) {
            this.createNotificationChannelGroup(group);
        }
    }

    @Implementation(minSdk=26)
    protected List<NotificationChannelGroup> getNotificationChannelGroups() {
        return ImmutableList.copyOf(notificationChannelGroups.values());
    }

    @Implementation(minSdk=26)
    protected void createNotificationChannel(NotificationChannel channel) {
        NotificationChannel existingChannel;
        String id2 = (String)ReflectionHelpers.callInstanceMethod((Object)channel, (String)"getId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        if (deletedNotificationChannels.containsKey(id2)) {
            notificationChannels.put(id2, deletedNotificationChannels.remove(id2));
        }
        if ((existingChannel = notificationChannels.get(id2)) != null) {
            existingChannel.setName(channel.getName());
            existingChannel.setDescription(channel.getDescription());
            if (channel.getImportance() < existingChannel.getImportance()) {
                existingChannel.setImportance(channel.getImportance());
            }
            if (Strings.isNullOrEmpty((String)existingChannel.getGroup())) {
                existingChannel.setGroup(channel.getGroup());
            }
            return;
        }
        notificationChannels.put(id2, channel);
    }

    @Implementation(minSdk=26)
    protected void createNotificationChannels(List<NotificationChannel> channelList) {
        for (NotificationChannel channel : channelList) {
            this.createNotificationChannel(channel);
        }
    }

    @Implementation(minSdk=26)
    public List<NotificationChannel> getNotificationChannels() {
        return ImmutableList.copyOf(notificationChannels.values());
    }

    @Implementation(minSdk=26)
    protected void deleteNotificationChannel(String channelId) {
        if (this.getNotificationChannel(channelId) != null) {
            NotificationChannel channel = notificationChannels.remove(channelId);
            deletedNotificationChannels.put(channelId, channel);
        }
    }

    @Implementation(minSdk=26)
    protected void deleteNotificationChannelGroup(String channelGroupId) {
        if (this.getNotificationChannelGroup(channelGroupId) != null) {
            for (NotificationChannel channel : this.getNotificationChannels()) {
                String groupId = (String)ReflectionHelpers.callInstanceMethod((Object)channel, (String)"getGroup", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                if (!channelGroupId.equals(groupId)) continue;
                String channelId = (String)ReflectionHelpers.callInstanceMethod((Object)channel, (String)"getId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                this.deleteNotificationChannel(channelId);
            }
            notificationChannelGroups.remove(channelGroupId);
        }
    }

    @Implementation(minSdk=23)
    protected int getCurrentInterruptionFilter() {
        return currentInterruptionFilter;
    }

    @Implementation(minSdk=23)
    protected void setInterruptionFilter(int interruptionFilter) {
        currentInterruptionFilter = interruptionFilter;
    }

    @Implementation(minSdk=23)
    protected NotificationManager.Policy getNotificationPolicy() {
        return notificationPolicy;
    }

    public void setConsolidatedNotificationPolicy(NotificationManager.Policy policy) {
        consolidatedNotificationPolicy = policy;
    }

    @Implementation(minSdk=30)
    protected NotificationManager.Policy getConsolidatedNotificationPolicy() {
        return consolidatedNotificationPolicy;
    }

    @Implementation(minSdk=23)
    protected boolean isNotificationPolicyAccessGranted() {
        return isNotificationPolicyAccessGranted;
    }

    @Implementation(minSdk=27)
    protected boolean isNotificationListenerAccessGranted(ComponentName componentName) {
        return listenerAccessGrantedComponents.getOrDefault(componentName.flattenToString(), false);
    }

    @Implementation(minSdk=23)
    protected void setNotificationPolicy(NotificationManager.Policy policy) {
        notificationPolicy = policy;
    }

    public void setNotificationPolicyAccessGranted(boolean granted) {
        isNotificationPolicyAccessGranted = granted;
        if (!granted) {
            automaticZenRules.clear();
        }
    }

    @Implementation(minSdk=27)
    public void setNotificationListenerAccessGranted(ComponentName componentName, boolean granted) {
        listenerAccessGrantedComponents.put(componentName.flattenToString(), granted);
    }

    @Implementation(minSdk=24)
    protected AutomaticZenRule getAutomaticZenRule(String id2) {
        Objects.requireNonNull(id2);
        this.enforcePolicyAccess();
        return automaticZenRules.get(id2);
    }

    @Implementation(minSdk=24)
    protected Map<String, AutomaticZenRule> getAutomaticZenRules() {
        this.enforcePolicyAccess();
        return ImmutableMap.copyOf(automaticZenRules);
    }

    @Implementation(minSdk=24)
    protected String addAutomaticZenRule(AutomaticZenRule automaticZenRule) {
        Objects.requireNonNull(automaticZenRule);
        Objects.requireNonNull(automaticZenRule.getName());
        Preconditions.checkState((automaticZenRule.getOwner() != null || automaticZenRule.getConfigurationActivity() != null ? 1 : 0) != 0, (Object)"owner/configurationActivity cannot be null at the same time");
        Objects.requireNonNull(automaticZenRule.getConditionId());
        this.enforcePolicyAccess();
        String id2 = UUID.randomUUID().toString().replace("-", "");
        automaticZenRules.put(id2, this.copyAutomaticZenRule(automaticZenRule));
        return id2;
    }

    @Implementation(minSdk=24)
    protected boolean updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule) {
        Objects.requireNonNull(automaticZenRule);
        Objects.requireNonNull(automaticZenRule.getName());
        Preconditions.checkState((automaticZenRule.getOwner() != null || automaticZenRule.getConfigurationActivity() != null ? 1 : 0) != 0, (Object)"owner/configurationActivity cannot be null at the same time");
        Objects.requireNonNull(automaticZenRule.getConditionId());
        this.enforcePolicyAccess();
        if (id2 == null) {
            throw new IllegalArgumentException("Rule doesn't exist");
        }
        if (!automaticZenRules.containsKey(id2)) {
            throw new SecurityException("Cannot update rules not owned by your condition provider");
        }
        automaticZenRules.put(id2, this.copyAutomaticZenRule(automaticZenRule));
        return true;
    }

    @Implementation(minSdk=24)
    protected boolean removeAutomaticZenRule(String id2) {
        Objects.requireNonNull(id2);
        this.enforcePolicyAccess();
        return automaticZenRules.remove(id2) != null;
    }

    @Implementation(minSdk=29)
    protected String getNotificationDelegate() {
        return notificationDelegate;
    }

    @Implementation(minSdk=29)
    protected boolean canNotifyAsPackage(@Nonnull String pkg) {
        return canNotifyOnBehalfPackages.contains(pkg);
    }

    public void setCanNotifyAsPackage(@Nonnull String otherPackage, boolean canNotify) {
        if (canNotify) {
            canNotifyOnBehalfPackages.add(otherPackage);
        } else {
            canNotifyOnBehalfPackages.remove(otherPackage);
        }
    }

    @Implementation(minSdk=29)
    protected void setNotificationDelegate(String delegate) {
        notificationDelegate = delegate;
    }

    public void setEnforceMaxNotificationLimit(boolean enforceMaxNotificationLimit) {
        ShadowNotificationManager.enforceMaxNotificationLimit = enforceMaxNotificationLimit;
    }

    private void enforcePolicyAccess() {
        if (!isNotificationPolicyAccessGranted) {
            throw new SecurityException("Notification policy access denied");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AutomaticZenRule copyAutomaticZenRule(AutomaticZenRule automaticZenRule) {
        Parcel parcel = Parcel.obtain();
        try {
            automaticZenRule.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            AutomaticZenRule automaticZenRule2 = new AutomaticZenRule(parcel);
            return automaticZenRule2;
        }
        finally {
            parcel.recycle();
        }
    }

    public boolean isChannelDeleted(String channelId) {
        return deletedNotificationChannels.containsKey(channelId);
    }

    @Implementation(minSdk=28)
    public NotificationChannelGroup getNotificationChannelGroup(String id2) {
        return notificationChannelGroups.get(id2);
    }

    public int size() {
        return notifications.size();
    }

    public Notification getNotification(int id2) {
        PostedNotification postedNotification = notifications.get(new Key(null, id2));
        return postedNotification == null ? null : postedNotification.notification;
    }

    public Notification getNotification(String tag, int id2) {
        PostedNotification postedNotification = notifications.get(new Key(tag, id2));
        return postedNotification == null ? null : postedNotification.notification;
    }

    public List<Notification> getAllNotifications() {
        ArrayList<Notification> result = new ArrayList<Notification>(notifications.size());
        for (PostedNotification postedNotification : notifications.values()) {
            result.add(postedNotification.notification);
        }
        return result;
    }

    static {
        importance = 0;
    }

    private static final class Key {
        public final String tag;
        public final int id;

        private Key(String tag, int id2) {
            this.tag = tag;
            this.id = id2;
        }

        public int hashCode() {
            int hashCode = 17;
            hashCode = 37 * hashCode + (this.tag == null ? 0 : this.tag.hashCode());
            hashCode = 37 * hashCode + this.id;
            return hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return Objects.equals(this.tag, other.tag) && this.id == other.id;
        }
    }

    private static final class PostedNotification {
        private final Notification notification;
        private final long postedTimeMillis;

        private PostedNotification(Notification notification, long postedTimeMillis) {
            this.notification = notification;
            this.postedTimeMillis = postedTimeMillis;
        }
    }
}

