/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.BugreportManager;
import android.os.BugreportParams;
import android.os.ParcelFileDescriptor;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=BugreportManager.class, minSdk=29, isInAndroidSdk=false)
public class ShadowBugreportManager {
    private boolean hasPermission = true;
    @Nullable
    private ParcelFileDescriptor bugreportFd;
    @Nullable
    private ParcelFileDescriptor screenshotFd;
    @Nullable
    private Executor executor;
    @Nullable
    private BugreportManager.BugreportCallback callback;
    private boolean bugreportRequested;
    @Nullable
    private CharSequence shareTitle;
    @Nullable
    private CharSequence shareDescription;

    @Implementation
    protected void startBugreport(ParcelFileDescriptor bugreportFd, ParcelFileDescriptor screenshotFd, BugreportParams params, Executor executor, BugreportManager.BugreportCallback callback) {
        this.enforcePermission("startBugreport");
        if (this.isBugreportInProgress()) {
            executor.execute(() -> callback.onError(5));
        } else {
            this.bugreportFd = bugreportFd;
            this.screenshotFd = screenshotFd;
            this.executor = executor;
            this.callback = callback;
        }
    }

    @Implementation(minSdk=30)
    protected void requestBugreport(BugreportParams params, CharSequence shareTitle, CharSequence shareDescription) {
        this.bugreportRequested = true;
        this.shareTitle = shareTitle;
        this.shareDescription = shareDescription;
    }

    @Implementation(minSdk=34)
    protected void retrieveBugreport(String bugreportFile, ParcelFileDescriptor bugreportFd, Executor executor, BugreportManager.BugreportCallback callback) {
        this.enforcePermission("retrieveBugreport");
        if (this.isBugreportInProgress()) {
            executor.execute(() -> callback.onError(5));
        } else {
            this.bugreportFd = bugreportFd;
            this.executor = executor;
            this.callback = callback;
        }
    }

    @Implementation
    protected void cancelBugreport() {
        this.enforcePermission("cancelBugreport");
        this.executeOnError(2);
    }

    public void executeOnProgress(float progress) {
        if (this.isBugreportInProgress()) {
            BugreportManager.BugreportCallback callback = this.callback;
            this.executor.execute(() -> callback.onProgress(progress));
        }
    }

    public void executeOnError(int errorCode) {
        if (this.isBugreportInProgress()) {
            BugreportManager.BugreportCallback callback = this.callback;
            this.executor.execute(() -> callback.onError(errorCode));
        }
        this.resetParams();
    }

    public void executeOnFinished() {
        if (this.isBugreportInProgress()) {
            BugreportManager.BugreportCallback callback = this.callback;
            this.executor.execute(() -> ((BugreportManager.BugreportCallback)callback).onFinished());
        }
        this.resetParams();
    }

    public void executeOnFinished(String bugreportFile) {
        if (this.isBugreportInProgress()) {
            BugreportManager.BugreportCallback callback = this.callback;
            this.executor.execute(() -> callback.onFinished(bugreportFile));
        }
        this.resetParams();
    }

    public boolean isBugreportInProgress() {
        return this.executor != null && this.callback != null;
    }

    public boolean wasBugreportRequested() {
        return this.bugreportRequested;
    }

    public void setHasPermission(boolean hasPermission) {
        this.hasPermission = hasPermission;
    }

    private void enforcePermission(String message) {
        if (!this.hasPermission) {
            throw new SecurityException(message);
        }
    }

    @Nullable
    public CharSequence getShareTitle() {
        return this.shareTitle;
    }

    @Nullable
    public CharSequence getShareDescription() {
        return this.shareDescription;
    }

    @Nullable
    public ParcelFileDescriptor getBugreportFd() {
        return this.bugreportFd;
    }

    @Nullable
    public ParcelFileDescriptor getScreenshotFd() {
        return this.screenshotFd;
    }

    private void resetParams() {
        try {
            if (this.bugreportFd != null) {
                this.bugreportFd.close();
            }
            if (this.screenshotFd != null) {
                this.screenshotFd.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bugreportFd = null;
        this.screenshotFd = null;
        this.executor = null;
        this.callback = null;
        this.bugreportRequested = false;
        this.shareTitle = null;
        this.shareDescription = null;
    }
}

