/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.shadows.BluetoothConnectionManager;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;

@Implements(value=BluetoothGattServer.class, minSdk=26)
public class ShadowBluetoothGattServer {
    private BluetoothGattServerCallback callback;
    private final List<byte[]> responses = new ArrayList<byte[]>();
    private final List<byte[]> writtenBytes = new ArrayList<byte[]>();
    private final Set<BluetoothDevice> cancelledDevices = new HashSet<BluetoothDevice>();
    private boolean isClosed;
    private final Set<BluetoothGattService> services = new HashSet<BluetoothGattService>();
    @ReflectorObject
    protected BluetoothGattServerReflector bluetoothGattServerReflector;

    @Implementation
    protected void close() {
        this.bluetoothGattServerReflector.close();
        this.isClosed = true;
    }

    @Implementation
    protected void cancelConnection(BluetoothDevice device) {
        this.bluetoothGattServerReflector.cancelConnection(device);
        this.cancelledDevices.add(device);
    }

    @Implementation
    protected boolean sendResponse(BluetoothDevice device, int requestId, int status, int offset, byte[] value) {
        this.responses.add(value);
        return this.bluetoothGattServerReflector.sendResponse(device, requestId, status, offset, value);
    }

    @Implementation
    protected boolean addService(BluetoothGattService service) {
        this.bluetoothGattServerReflector.addService(service);
        this.services.add(service);
        return true;
    }

    @Implementation
    protected boolean removeService(BluetoothGattService service) {
        return this.services.remove(service);
    }

    @Implementation
    protected void clearServices() {
        this.services.clear();
    }

    @Implementation
    protected List<BluetoothGattService> getServices() {
        return ImmutableList.copyOf(this.services);
    }

    @Implementation
    protected BluetoothGattService getService(UUID uuid) {
        return this.services.stream().filter(s -> s.getUuid().equals(uuid)).findFirst().orElse(null);
    }

    public void notifyConnection(BluetoothDevice device) {
        BluetoothConnectionManager.getInstance().registerGattServerConnection(device.getAddress());
        this.cancelledDevices.remove(device);
        if (this.callback != null) {
            this.callback.onConnectionStateChange(device, 0, 2);
        }
    }

    public void notifyDisconnection(BluetoothDevice device) {
        BluetoothConnectionManager.getInstance().unregisterGattServerConnection(device.getAddress());
        this.cancelledDevices.add(device);
        if (this.callback != null) {
            this.callback.onConnectionStateChange(device, 0, 0);
        }
    }

    public boolean notifyOnCharacteristicWriteRequest(BluetoothDevice device, int requestId, BluetoothGattCharacteristic characteristic, Boolean preparedWrite, Boolean responseNeeded, int offset, byte[] value) {
        if (this.callback == null) {
            return false;
        }
        if ((characteristic.getProperties() & 8) == 0 && (characteristic.getProperties() & 4) == 0) {
            return false;
        }
        this.writtenBytes.add(value);
        this.callback.onCharacteristicWriteRequest(device, requestId, characteristic, preparedWrite.booleanValue(), responseNeeded.booleanValue(), offset, value);
        return true;
    }

    public boolean isConnectionCancelled(BluetoothDevice device) {
        return this.cancelledDevices.contains(device);
    }

    public boolean isConnectedToDevice(BluetoothDevice device) {
        return BluetoothConnectionManager.getInstance().hasGattServerConnection(device.getAddress());
    }

    public List<byte[]> getResponses() {
        ArrayList<byte[]> responsesCopy = new ArrayList<byte[]>();
        for (byte[] response : this.responses) {
            if (response != null) {
                responsesCopy.add((byte[])response.clone());
                continue;
            }
            responsesCopy.add(null);
        }
        return responsesCopy;
    }

    public void clearResponses() {
        this.responses.clear();
    }

    public List<byte[]> getWrittenBytes() {
        return Lists.transform(this.writtenBytes, bytes -> bytes != null ? (byte[])bytes.clone() : null);
    }

    public void clearWrittenBytes() {
        this.writtenBytes.clear();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setGattServerCallback(BluetoothGattServerCallback callback) {
        this.callback = callback;
    }

    public BluetoothGattServerCallback getGattServerCallback() {
        return this.callback;
    }

    public BluetoothConnectionManager getBluetoothConnectionManager() {
        return BluetoothConnectionManager.getInstance();
    }

    @ForType(value=BluetoothGattServer.class)
    private static interface BluetoothGattServerReflector {
        @Direct
        public void close();

        @Direct
        public void cancelConnection(BluetoothDevice var1);

        @Direct
        public boolean sendResponse(BluetoothDevice var1, int var2, int var3, int var4, byte[] var5);

        @Direct
        public boolean addService(BluetoothGattService var1);
    }
}

