/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.Registries;
import org.robolectric.res.android.ResXMLParser;
import org.robolectric.res.android.ResXMLTree;
import org.robolectric.res.android.ResourceTypes;
import org.xmlpull.v1.XmlPullParserException;

@Implements(className="android.content.res.XmlBlock", isInAndroidSdk=false)
public class ShadowXmlBlock {
    @Implementation
    protected static long nativeCreate(byte[] bArray, int off, int len) {
        if (bArray == null) {
            throw new NullPointerException();
        }
        int bLen = bArray.length;
        if (off < 0 || off >= bLen || len < 0 || len > bLen || off + len > bLen) {
            throw new IndexOutOfBoundsException();
        }
        byte[] b = new byte[len];
        System.arraycopy(bArray, off, b, 0, len);
        ResXMLTree osb = new ResXMLTree(null);
        osb.setTo(b, len, true);
        if (osb.getError() != 0) {
            throw new IllegalArgumentException();
        }
        return Registries.NATIVE_RES_XML_TREES.register((Object)osb);
    }

    @Implementation
    protected static long nativeGetStringBlock(long obj) {
        ResXMLTree osb = (ResXMLTree)Registries.NATIVE_RES_XML_TREES.getNativeObject(obj);
        return osb.getStrings().getNativePtr();
    }

    @Implementation(maxSdk=28)
    protected static long nativeCreateParseState(long obj) {
        ResXMLTree osb = (ResXMLTree)Registries.NATIVE_RES_XML_TREES.getNativeObject(obj);
        ResXMLParser st = new ResXMLParser(osb);
        st.restart();
        return Registries.NATIVE_RES_XML_PARSERS.register((Object)st);
    }

    @Implementation(minSdk=29)
    protected static long nativeCreateParseState(long obj, int resid) {
        ResXMLTree osb = (ResXMLTree)Registries.NATIVE_RES_XML_TREES.getNativeObject(obj);
        ResXMLParser st = new ResXMLParser(osb);
        st.setSourceResourceId(resid);
        st.restart();
        return Registries.NATIVE_RES_XML_PARSERS.register((Object)st);
    }

    @Implementation
    protected static int nativeNext(long state) throws XmlPullParserException {
        ResXMLParser st = ShadowXmlBlock.getResXMLParser(state);
        if (st == null) {
            return 1;
        }
        while (true) {
            int code = st.next();
            switch (code) {
                case 258: {
                    return 2;
                }
                case 259: {
                    return 3;
                }
                case 260: {
                    return 4;
                }
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case -1: {
                    throw new XmlPullParserException("Corrupt XML binary file");
                }
            }
        }
    }

    @Implementation
    protected static int nativeGetNamespace(long state) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        if (resXMLParser == null) {
            return -1;
        }
        return resXMLParser.getElementNamespaceID();
    }

    @Implementation
    protected static int nativeGetName(long state) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        if (resXMLParser == null) {
            return -1;
        }
        return resXMLParser.getElementNameID();
    }

    @Implementation
    protected static int nativeGetText(long state) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        if (resXMLParser == null) {
            return -1;
        }
        return resXMLParser.getTextID();
    }

    @Implementation
    protected static int nativeGetLineNumber(long state) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        return resXMLParser.getLineNumber();
    }

    @Implementation
    protected static int nativeGetAttributeCount(long state) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        return resXMLParser.getAttributeCount();
    }

    @Implementation
    protected static int nativeGetAttributeNamespace(long state, int idx) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        return resXMLParser.getAttributeNamespaceID(idx);
    }

    @Implementation
    protected static int nativeGetAttributeName(long state, int idx) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        return resXMLParser.getAttributeNameID(idx);
    }

    @Implementation
    protected static int nativeGetAttributeResource(long state, int idx) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        return resXMLParser.getAttributeNameResID(idx);
    }

    @Implementation
    protected static int nativeGetAttributeDataType(long state, int idx) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        return resXMLParser.getAttributeDataType(idx);
    }

    @Implementation
    protected static int nativeGetAttributeData(long state, int idx) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        return resXMLParser.getAttributeData(idx);
    }

    @Implementation
    protected static int nativeGetAttributeStringValue(long state, int idx) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        return resXMLParser.getAttributeValueStringID(idx);
    }

    @Implementation
    protected static int nativeGetIdAttribute(long state) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        int idx = resXMLParser.indexOfID();
        return idx >= 0 ? resXMLParser.getAttributeValueStringID(idx) : -1;
    }

    @Implementation
    protected static int nativeGetClassAttribute(long state) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        int idx = resXMLParser.indexOfClass();
        return idx >= 0 ? resXMLParser.getAttributeValueStringID(idx) : -1;
    }

    @Implementation
    protected static int nativeGetStyleAttribute(long state) {
        ResXMLParser resXMLParser = ShadowXmlBlock.getResXMLParser(state);
        int idx = resXMLParser.indexOfStyle();
        if (idx < 0) {
            return 0;
        }
        Ref valueRef = new Ref((Object)new ResourceTypes.Res_value());
        if (resXMLParser.getAttributeValue(idx, valueRef) < 0) {
            return 0;
        }
        ResourceTypes.Res_value value = (ResourceTypes.Res_value)valueRef.get();
        return value.dataType == 1 || value.dataType == 2 ? value.data : 0;
    }

    @Implementation
    protected static int nativeGetAttributeIndex(long token, String ns, String name) {
        ResXMLParser st = ShadowXmlBlock.getResXMLParser(token);
        if (st == null || name == null) {
            throw new NullPointerException();
        }
        int nsLen = 0;
        if (ns != null) {
            nsLen = ns.length();
        }
        return st.indexOfAttribute(ns, nsLen, name, name.length());
    }

    @Implementation(minSdk=29)
    protected static int nativeGetSourceResId(long state) {
        ResXMLParser st = ShadowXmlBlock.getResXMLParser(state);
        if (st == null) {
            return 0;
        }
        return st.getSourceResourceId();
    }

    @Implementation
    protected static void nativeDestroyParseState(long state) {
        Registries.NATIVE_RES_XML_PARSERS.unregister(state);
    }

    @Implementation
    protected static void nativeDestroy(long obj) {
        Registries.NATIVE_RES_XML_TREES.unregister(obj);
    }

    private static ResXMLParser getResXMLParser(long state) {
        return (ResXMLParser)Registries.NATIVE_RES_XML_PARSERS.peekNativeObject(state);
    }

    @Implements(className="android.content.res.XmlBlock$Parser", isInAndroidSdk=false)
    public static class ShadowParser {
        private int sourceResourceId;

        void setSourceResourceId(int sourceResourceId) {
            this.sourceResourceId = sourceResourceId;
        }

        int getSourceResourceId() {
            return this.sourceResourceId;
        }
    }
}

