/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.ProxyInfo;
import android.os.Handler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowNetwork;
import org.robolectric.shadows.ShadowNetworkCapabilities;
import org.robolectric.shadows.ShadowNetworkInfo;
import org.robolectric.shadows.ShadowSettings;

@Implements(value=ConnectivityManager.class)
public class ShadowConnectivityManager {
    static final int NET_ID_WIFI = 1;
    static final int NET_ID_MOBILE = 0;
    private NetworkInfo activeNetworkInfo;
    private boolean backgroundDataSetting;
    private int restrictBackgroundStatus = 1;
    private int networkPreference = 1;
    private final Map<Integer, NetworkInfo> networkTypeToNetworkInfo = new HashMap<Integer, NetworkInfo>();
    private HashSet<ConnectivityManager.NetworkCallback> networkCallbacks = new HashSet();
    private final HashSet<PendingIntent> networkCallbackPendingIntents = new HashSet();
    private final Map<Integer, Network> netIdToNetwork = new HashMap<Integer, Network>();
    private final Map<Integer, NetworkInfo> netIdToNetworkInfo = new HashMap<Integer, NetworkInfo>();
    private Network processBoundNetwork;
    private boolean defaultNetworkActive;
    private HashSet<ConnectivityManager.OnNetworkActiveListener> onNetworkActiveListeners = new HashSet();
    private Map<Network, Boolean> reportedNetworkConnectivity = new HashMap<Network, Boolean>();
    private Map<Network, NetworkCapabilities> networkCapabilitiesMap = new HashMap<Network, NetworkCapabilities>();
    private String captivePortalServerUrl = "http://10.0.0.2";
    private final Map<Network, LinkProperties> linkPropertiesMap = new HashMap<Network, LinkProperties>();
    private final Map<Network, ProxyInfo> proxyInfoMap = new HashMap<Network, ProxyInfo>();

    public ShadowConnectivityManager() {
        NetworkInfo wifi = ShadowNetworkInfo.newInstance(NetworkInfo.DetailedState.DISCONNECTED, 1, 0, true, false);
        this.networkTypeToNetworkInfo.put(1, wifi);
        NetworkInfo mobile = ShadowNetworkInfo.newInstance(NetworkInfo.DetailedState.CONNECTED, 0, 2, true, true);
        this.networkTypeToNetworkInfo.put(0, mobile);
        this.activeNetworkInfo = mobile;
        this.netIdToNetwork.put(1, ShadowNetwork.newInstance(1));
        this.netIdToNetwork.put(0, ShadowNetwork.newInstance(0));
        this.netIdToNetworkInfo.put(1, wifi);
        this.netIdToNetworkInfo.put(0, mobile);
        NetworkCapabilities wifiNetworkCapabilities = ShadowNetworkCapabilities.newInstance();
        Shadows.shadowOf(wifiNetworkCapabilities).addTransportType(1);
        NetworkCapabilities mobileNetworkCapabilities = ShadowNetworkCapabilities.newInstance();
        Shadows.shadowOf(mobileNetworkCapabilities).addTransportType(0);
        this.networkCapabilitiesMap.put(this.netIdToNetwork.get(1), wifiNetworkCapabilities);
        this.networkCapabilitiesMap.put(this.netIdToNetwork.get(0), mobileNetworkCapabilities);
        this.defaultNetworkActive = true;
    }

    public Set<ConnectivityManager.NetworkCallback> getNetworkCallbacks() {
        return this.networkCallbacks;
    }

    public Set<PendingIntent> getNetworkCallbackPendingIntents() {
        return this.networkCallbackPendingIntents;
    }

    public Map<Network, Boolean> getReportedNetworkConnectivity() {
        return new HashMap<Network, Boolean>(this.reportedNetworkConnectivity);
    }

    @Implementation
    protected void registerNetworkCallback(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback) {
        this.registerNetworkCallback(request, networkCallback, null);
    }

    @Implementation(minSdk=26)
    protected void registerNetworkCallback(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
        this.networkCallbacks.add(networkCallback);
    }

    @Implementation(minSdk=23)
    protected void registerNetworkCallback(NetworkRequest request, PendingIntent pendingIntent) {
        this.networkCallbackPendingIntents.add(pendingIntent);
    }

    @Implementation
    protected void requestNetwork(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback) {
        this.registerNetworkCallback(request, networkCallback);
    }

    @Implementation(minSdk=26)
    protected void requestNetwork(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback, int timeoutMs) {
        this.registerNetworkCallback(request, networkCallback);
    }

    @Implementation(minSdk=26)
    protected void requestNetwork(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
        this.registerNetworkCallback(request, networkCallback);
    }

    @Implementation(minSdk=26)
    protected void requestNetwork(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback, Handler handler, int timeoutMs) {
        this.registerNetworkCallback(request, networkCallback);
    }

    @Implementation(minSdk=24)
    protected void registerDefaultNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
        this.networkCallbacks.add(networkCallback);
    }

    @Implementation(minSdk=26)
    protected void registerDefaultNetworkCallback(ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
        this.networkCallbacks.add(networkCallback);
    }

    @Implementation(minSdk=31)
    protected void registerBestMatchingNetworkCallback(NetworkRequest request, ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
        this.networkCallbacks.add(networkCallback);
    }

    @Implementation
    protected void unregisterNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
        if (networkCallback == null) {
            throw new IllegalArgumentException("Invalid NetworkCallback");
        }
        if (this.networkCallbacks.contains(networkCallback)) {
            this.networkCallbacks.remove(networkCallback);
        }
    }

    @Implementation(minSdk=23)
    protected void unregisterNetworkCallback(PendingIntent pendingIntent) {
        if (pendingIntent == null) {
            throw new IllegalArgumentException("Invalid NetworkCallback");
        }
        if (this.networkCallbackPendingIntents.contains(pendingIntent)) {
            this.networkCallbackPendingIntents.remove(pendingIntent);
        }
    }

    @Implementation
    protected NetworkInfo getActiveNetworkInfo() {
        return this.activeNetworkInfo;
    }

    @Implementation(minSdk=23)
    protected Network getActiveNetwork() {
        if (this.defaultNetworkActive) {
            return this.netIdToNetwork.get(this.getActiveNetworkInfo().getType());
        }
        return null;
    }

    @Implementation
    protected NetworkInfo[] getAllNetworkInfo() {
        if (this.defaultNetworkActive) {
            return this.networkTypeToNetworkInfo.values().toArray(new NetworkInfo[this.networkTypeToNetworkInfo.size()]);
        }
        return null;
    }

    @Implementation
    protected NetworkInfo getNetworkInfo(int networkType) {
        return this.networkTypeToNetworkInfo.get(networkType);
    }

    @Implementation
    protected NetworkInfo getNetworkInfo(Network network) {
        if (network == null) {
            return null;
        }
        ShadowNetwork shadowNetwork = (ShadowNetwork)Shadow.extract((Object)network);
        return this.netIdToNetworkInfo.get(shadowNetwork.getNetId());
    }

    @Implementation
    protected Network[] getAllNetworks() {
        return this.netIdToNetwork.values().toArray(new Network[this.netIdToNetwork.size()]);
    }

    @Implementation
    protected boolean getBackgroundDataSetting() {
        return this.backgroundDataSetting;
    }

    @Implementation
    protected void setNetworkPreference(int preference) {
        this.networkPreference = preference;
    }

    @Implementation
    protected int getNetworkPreference() {
        return this.networkPreference;
    }

    @Implementation
    protected boolean isActiveNetworkMetered() {
        if (this.defaultNetworkActive && this.activeNetworkInfo != null) {
            return this.activeNetworkInfo.getType() == 0;
        }
        return false;
    }

    @Implementation(minSdk=23)
    protected boolean bindProcessToNetwork(Network network) {
        this.processBoundNetwork = network;
        return true;
    }

    @Implementation(minSdk=23)
    protected Network getBoundNetworkForProcess() {
        return this.processBoundNetwork;
    }

    public void setNetworkInfo(int networkType, NetworkInfo networkInfo) {
        this.networkTypeToNetworkInfo.put(networkType, networkInfo);
    }

    @Implementation(minSdk=24)
    protected String getCaptivePortalServerUrl() {
        return this.captivePortalServerUrl;
    }

    public void setCaptivePortalServerUrl(String captivePortalServerUrl) {
        this.captivePortalServerUrl = captivePortalServerUrl;
    }

    @HiddenApi
    @Implementation
    public void setBackgroundDataSetting(boolean b) {
        this.backgroundDataSetting = b;
    }

    public void setActiveNetworkInfo(NetworkInfo info) {
        this.activeNetworkInfo = info;
        if (info != null) {
            this.networkTypeToNetworkInfo.put(info.getType(), info);
            this.netIdToNetwork.put(info.getType(), ShadowNetwork.newInstance(info.getType()));
            this.netIdToNetworkInfo.put(info.getType(), info);
        } else {
            this.networkTypeToNetworkInfo.clear();
            this.netIdToNetwork.clear();
        }
    }

    public void addNetwork(Network network, NetworkInfo networkInfo) {
        ShadowNetwork shadowNetwork = (ShadowNetwork)Shadow.extract((Object)network);
        int netId = shadowNetwork.getNetId();
        this.netIdToNetwork.put(netId, network);
        this.netIdToNetworkInfo.put(netId, networkInfo);
    }

    public void removeNetwork(Network network) {
        ShadowNetwork shadowNetwork = (ShadowNetwork)Shadow.extract((Object)network);
        int netId = shadowNetwork.getNetId();
        this.netIdToNetwork.remove(netId);
        this.netIdToNetworkInfo.remove(netId);
    }

    public void clearAllNetworks() {
        this.netIdToNetwork.clear();
        this.netIdToNetworkInfo.clear();
    }

    public void setDefaultNetworkActive(boolean isActive) {
        this.defaultNetworkActive = isActive;
        if (this.defaultNetworkActive) {
            for (ConnectivityManager.OnNetworkActiveListener l : this.onNetworkActiveListeners) {
                if (l == null) continue;
                l.onNetworkActive();
            }
        }
    }

    @Implementation
    protected boolean isDefaultNetworkActive() {
        return this.defaultNetworkActive;
    }

    @Implementation
    protected void addDefaultNetworkActiveListener(ConnectivityManager.OnNetworkActiveListener l) {
        this.onNetworkActiveListeners.add(l);
    }

    @Implementation
    protected void removeDefaultNetworkActiveListener(ConnectivityManager.OnNetworkActiveListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Invalid OnNetworkActiveListener");
        }
        if (this.onNetworkActiveListeners.contains(l)) {
            this.onNetworkActiveListeners.remove(l);
        }
    }

    @Implementation(minSdk=23)
    protected void reportNetworkConnectivity(Network network, boolean hasConnectivity) {
        this.reportedNetworkConnectivity.put(network, hasConnectivity);
    }

    @Implementation
    protected NetworkCapabilities getNetworkCapabilities(Network network) {
        return this.networkCapabilitiesMap.get(network);
    }

    public void setNetworkCapabilities(Network network, NetworkCapabilities networkCapabilities) {
        this.networkCapabilitiesMap.put(network, networkCapabilities);
    }

    @Implementation
    protected void setAirplaneMode(boolean enable) {
        ShadowSettings.setAirplaneMode(enable);
    }

    @Implementation
    protected LinkProperties getLinkProperties(Network network) {
        return this.linkPropertiesMap.get(network);
    }

    public void setLinkProperties(Network network, LinkProperties linkProperties) {
        this.linkPropertiesMap.put(network, linkProperties);
    }

    @Implementation(minSdk=24)
    protected int getRestrictBackgroundStatus() {
        return this.restrictBackgroundStatus;
    }

    public void setRestrictBackgroundStatus(int status) {
        if (status <= 0 || status >= 4) {
            throw new IllegalArgumentException("Invalid RESTRICT_BACKGROUND_STATUS value.");
        }
        this.restrictBackgroundStatus = status;
    }

    public void setProxyForNetwork(Network network, ProxyInfo proxyInfo) {
        this.proxyInfoMap.put(network, proxyInfo);
    }

    @Implementation(minSdk=23)
    protected ProxyInfo getProxyForNetwork(Network network) {
        return this.proxyInfoMap.get(network);
    }
}

