/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.backup.BackupManager;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreSession;
import android.app.backup.RestoreSet;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=BackupManager.class)
public class ShadowBackupManager {
    private static BackupManagerServiceState serviceState = new BackupManagerServiceState();
    @RealObject
    private BackupManager realBackupManager;
    private Context context;

    @Resetter
    public static void reset() {
        serviceState = new BackupManagerServiceState();
    }

    @Implementation
    protected void __constructor__(Context context) {
        this.context = context;
        Shadow.invokeConstructor(BackupManager.class, (Object)this.realBackupManager, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
    }

    @Implementation
    protected void dataChanged() {
        ShadowBackupManager.serviceState.dataChangedCount.merge(this.context.getPackageName(), 1, Integer::sum);
    }

    public boolean isDataChanged() {
        return ShadowBackupManager.serviceState.dataChangedCount.containsKey(this.context.getPackageName());
    }

    public int getDataChangedCount() {
        return ShadowBackupManager.serviceState.dataChangedCount.getOrDefault(this.context.getPackageName(), 0);
    }

    @Implementation
    @HiddenApi
    protected void setBackupEnabled(boolean isEnabled) {
        this.enforceBackupPermission("setBackupEnabled");
        ShadowBackupManager.serviceState.backupEnabled = isEnabled;
    }

    @Implementation
    @HiddenApi
    protected boolean isBackupEnabled() {
        this.enforceBackupPermission("isBackupEnabled");
        return ShadowBackupManager.serviceState.backupEnabled;
    }

    @Implementation
    @HiddenApi
    protected RestoreSession beginRestoreSession() {
        this.enforceBackupPermission("beginRestoreSession");
        return (RestoreSession)ReflectionHelpers.callConstructor(RestoreSession.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)this.context), ReflectionHelpers.ClassParameter.from(IRestoreSession.class, (Object)new FakeRestoreSession())});
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected long getAvailableRestoreToken(String packageName) {
        this.enforceBackupPermission("getAvailableRestoreToken");
        return this.getPackageRestoreToken(packageName);
    }

    public long getPackageRestoreToken(String packageName) {
        List result = ShadowBackupManager.serviceState.restoredPackages.get((Object)packageName);
        return result.isEmpty() ? 0L : (Long)result.get(result.size() - 1);
    }

    public int getPackageRestoreCount(String packageName) {
        return ShadowBackupManager.serviceState.restoredPackages.get((Object)packageName).size();
    }

    public void addAvailableRestoreSets(long restoreToken, List<String> packages) {
        this.addAvailableRestoreSets(restoreToken, packages, 0);
    }

    public void addAvailableRestoreSets(long restoreToken, List<String> packages, int result) {
        ShadowBackupManager.serviceState.restoreData.put((Object)restoreToken, (Object)new RestoreData(packages, result));
    }

    public void setNullAvailableRestoreSets(boolean value) {
        ShadowBackupManager.serviceState.nullRestoreData = value;
    }

    private void enforceBackupPermission(String message) {
        RuntimeEnvironment.getApplication().enforceCallingOrSelfPermission("android.permission.BACKUP", message);
    }

    private static class BackupManagerServiceState {
        boolean backupEnabled = true;
        boolean nullRestoreData;
        long lastRestoreToken = 0L;
        final Map<String, Integer> dataChangedCount = new HashMap<String, Integer>();
        final ListMultimap<Long, RestoreData> restoreData = ArrayListMultimap.create();
        final ListMultimap<String, Long> restoredPackages = ArrayListMultimap.create();

        private BackupManagerServiceState() {
        }

        RestoreData takeRestoreData(long token) {
            List results = this.restoreData.get((Object)token);
            if (results.isEmpty()) {
                return new RestoreData(new ArrayList<String>(), -1);
            }
            RestoreData data = (RestoreData)results.get(0);
            if (results.size() > 1) {
                this.restoreData.remove((Object)token, (Object)data);
            }
            return data;
        }
    }

    private static class FakeRestoreSession
    implements IRestoreSession {
        private FakeRestoreSession() {
        }

        public int getAvailableRestoreSets(IRestoreObserver observer) throws RemoteException {
            return this.getAvailableRestoreSets(observer, null);
        }

        public int getAvailableRestoreSets(IRestoreObserver observer, IBackupManagerMonitor monitor) throws RemoteException {
            this.post(() -> {
                if (serviceState.nullRestoreData) {
                    observer.restoreSetsAvailable(null);
                    return;
                }
                Set restoreTokens = serviceState.restoreData.keySet();
                HashSet<RestoreSet> restoreSets = new HashSet<RestoreSet>();
                Iterator iterator = restoreTokens.iterator();
                while (iterator.hasNext()) {
                    long token = (Long)iterator.next();
                    restoreSets.add(new RestoreSet("RestoreSet-" + token, "device", token));
                }
                observer.restoreSetsAvailable(restoreSets.toArray(new RestoreSet[0]));
            });
            return 0;
        }

        public int restoreAll(long token, IRestoreObserver observer) throws RemoteException {
            return this.restoreAll(token, observer, null);
        }

        public int restoreAll(long token, IRestoreObserver observer, IBackupManagerMonitor monitor) throws RemoteException {
            return this.restorePackages(token, observer, null, monitor);
        }

        public int restoreSome(long token, IRestoreObserver observer, String[] packages) throws RemoteException {
            return this.restorePackages(token, observer, packages, null);
        }

        public int restoreSome(long token, IRestoreObserver observer, IBackupManagerMonitor monitor, String[] packages) throws RemoteException {
            return this.restorePackages(token, observer, packages, monitor);
        }

        public int restorePackages(long token, IRestoreObserver observer, String[] packages, IBackupManagerMonitor monitor) throws RemoteException {
            RestoreData restoreData = serviceState.takeRestoreData(token);
            ArrayList<String> restorePackages = new ArrayList<String>(restoreData.packages);
            if (packages != null) {
                restorePackages.retainAll(Arrays.asList(packages));
            }
            this.post(() -> observer.restoreStarting(restorePackages.size()));
            int i = 0;
            while (i < restorePackages.size()) {
                int index = i++;
                this.post(() -> observer.onUpdate(index, (String)restorePackages.get(index)));
                serviceState.restoredPackages.put((Object)((String)restorePackages.get(index)), (Object)token);
            }
            this.post(() -> observer.restoreFinished(restoreData.result));
            serviceState.lastRestoreToken = token;
            return 0;
        }

        public int restorePackage(String packageName, IRestoreObserver observer) throws RemoteException {
            return this.restorePackage(packageName, observer, null);
        }

        public int restorePackage(String packageName, IRestoreObserver observer, IBackupManagerMonitor monitor) throws RemoteException {
            if (serviceState.lastRestoreToken == 0L) {
                return -1;
            }
            RestoreData restoreData = serviceState.takeRestoreData(serviceState.lastRestoreToken);
            ArrayList<String> restorePackages = new ArrayList<String>(restoreData.packages);
            if (!restorePackages.contains(packageName)) {
                return -2002;
            }
            this.post(() -> observer.restoreStarting(1));
            this.post(() -> observer.onUpdate(0, packageName));
            serviceState.restoredPackages.put((Object)packageName, (Object)serviceState.lastRestoreToken);
            this.post(() -> observer.restoreFinished(restoreData.result));
            return 0;
        }

        public void endRestoreSession() throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }

        private void post(RemoteRunnable runnable) {
            new Handler(Looper.getMainLooper()).post(() -> {
                try {
                    runnable.run();
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static class RestoreData {
        final List<String> packages;
        final int result;

        public RestoreData(List<String> packages, int result) {
            this.packages = packages;
            this.result = result;
        }
    }

    private static interface RemoteRunnable {
        public void run() throws RemoteException;
    }
}

