/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.audiofx.AudioEffect;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AudioEffect.class)
public class ShadowAudioEffect {
    private static final List<AudioEffect.Descriptor> descriptors = new ArrayList<AudioEffect.Descriptor>();
    private static final List<AudioEffect> audioEffects = new ArrayList<AudioEffect>();
    private final Map<ByteBuffer, ByteBuffer> parameters = new HashMap<ByteBuffer, ByteBuffer>();
    @RealObject
    AudioEffect audioEffect;
    private int priority;
    private int audioSession;
    private boolean isEnabled = false;
    private int errorCode = 0;

    @Implementation(maxSdk=22)
    protected int native_setup(Object audioEffectThis, String type, String uuid, int priority, int audioSession, int[] id2, Object[] desc) {
        return this.native_setup(audioEffectThis, type, uuid, priority, audioSession, id2, desc, null);
    }

    @Implementation(minSdk=23, maxSdk=29)
    protected int native_setup(Object audioEffectThis, String type, String uuid, int priority, int audioSession, int[] id2, Object[] desc, String opPackageName) {
        audioEffects.add(this.audioEffect);
        this.priority = priority;
        this.audioSession = audioSession;
        return 0;
    }

    @Implementation
    protected int native_setEnabled(boolean enabled) {
        if (this.errorCode != 0) {
            return this.errorCode;
        }
        this.isEnabled = enabled;
        return 0;
    }

    @Implementation
    protected boolean native_getEnabled() {
        return this.isEnabled;
    }

    @Implementation
    protected int native_setParameter(int psize, byte[] param, int vsize, byte[] value) {
        if (this.errorCode != 0) {
            return this.errorCode;
        }
        ByteBuffer parameterKey = ShadowAudioEffect.createReadOnlyByteBuffer(param, psize);
        ByteBuffer parameterValue = ShadowAudioEffect.createReadOnlyByteBuffer(value, vsize);
        this.parameters.put(parameterKey, parameterValue);
        return 0;
    }

    @Implementation
    protected int native_getParameter(int psize, byte[] param, int vsize, byte[] value) {
        if (this.errorCode != 0) {
            return this.errorCode;
        }
        ByteBuffer parameterKey = ByteBuffer.wrap(Arrays.copyOf(param, psize));
        if (this.parameters.containsKey(parameterKey)) {
            ByteBuffer parameterValue = this.parameters.get(parameterKey);
            return ShadowAudioEffect.copyByteBufferToArrayAndReturnSize(parameterValue, value);
        }
        Optional<ByteBuffer> defaultValue = this.getDefaultParameter(parameterKey);
        if (defaultValue.isPresent()) {
            return ShadowAudioEffect.copyByteBufferToArrayAndReturnSize(defaultValue.get(), value);
        }
        byte[] val = AudioEffect.intToByteArray((int)0);
        System.arraycopy(val, 0, value, 0, 4);
        return 4;
    }

    private static int copyByteBufferToArrayAndReturnSize(ByteBuffer byteBuffer, byte[] array) {
        Preconditions.checkArgument((byteBuffer.position() == 0 ? 1 : 0) != 0);
        for (int i = 0; i < byteBuffer.limit(); ++i) {
            array[i] = byteBuffer.get(i);
        }
        return byteBuffer.limit();
    }

    protected Optional<ByteBuffer> getDefaultParameter(ByteBuffer parameter) {
        return Optional.empty();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getAudioSession() {
        return this.audioSession;
    }

    public void setInitialized(boolean initialized) {
        ((ReflectorAudioEffect)Reflector.reflector(ReflectorAudioEffect.class, (Object)this.audioEffect)).setState(initialized ? 1 : 0);
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public static void addEffect(AudioEffect.Descriptor descriptor) {
        descriptors.add(descriptor);
    }

    @Implementation
    protected static AudioEffect.Descriptor[] queryEffects() {
        return descriptors.toArray(new AudioEffect.Descriptor[descriptors.size()]);
    }

    public static ImmutableList<AudioEffect> getAudioEffects() {
        return ImmutableList.copyOf(audioEffects);
    }

    @Implementation
    protected void native_release() {
        audioEffects.remove(this.audioEffect);
    }

    static ByteBuffer createReadOnlyByteBuffer(byte[] array) {
        return ShadowAudioEffect.createReadOnlyByteBuffer(array, array.length);
    }

    static ByteBuffer createReadOnlyByteBuffer(byte[] array, int length) {
        return ByteBuffer.wrap(Arrays.copyOf(array, length)).asReadOnlyBuffer();
    }

    @Resetter
    public static void reset() {
        descriptors.clear();
        audioEffects.clear();
    }

    @ForType(value=AudioEffect.class)
    private static interface ReflectorAudioEffect {
        @Accessor(value="mState")
        public void setState(int var1);
    }
}

