/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.robolectric.shadows.AutoValue_BackupDataEntity;

@AutoValue
public abstract class BackupDataEntity {
    public abstract String key();

    public abstract int dataSize();

    public abstract byte[] data();

    public static BackupDataEntity createDeletedEntity(String key) {
        return new AutoValue_BackupDataEntity((String)Preconditions.checkNotNull((Object)key), -1, new byte[0]);
    }

    public static BackupDataEntity create(String key, String data) {
        return BackupDataEntity.create(key, data.getBytes(StandardCharsets.UTF_8));
    }

    public static BackupDataEntity create(String key, byte[] data) {
        return BackupDataEntity.create(key, data, data.length);
    }

    public static BackupDataEntity create(String key, byte[] data, int dataSize) {
        return new AutoValue_BackupDataEntity((String)Preconditions.checkNotNull((Object)key), dataSize, Arrays.copyOf(data, dataSize));
    }
}

