/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telephony.UiccCardInfo;
import android.telephony.UiccPortInfo;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

@RequiresApi(value=29)
public class UiccCardInfoBuilder {
    private int cardId;
    private String eid;
    private String iccId;
    private int slotIndex;
    private int physicalSlotIndex;
    private List<UiccPortInfo> portList = new ArrayList<UiccPortInfo>();
    private boolean isEuicc;
    private boolean isMultipleEnabledProfilesSupported;
    private boolean isRemovable;

    private UiccCardInfoBuilder() {
    }

    public static UiccCardInfoBuilder newBuilder() {
        return new UiccCardInfoBuilder();
    }

    @CanIgnoreReturnValue
    public UiccCardInfoBuilder setCardId(int cardId) {
        this.cardId = cardId;
        return this;
    }

    @CanIgnoreReturnValue
    public UiccCardInfoBuilder setEid(String eid) {
        this.eid = eid;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public UiccCardInfoBuilder setIccId(String iccId) {
        this.iccId = iccId;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public UiccCardInfoBuilder setSlotIndex(int slotIndex) {
        this.slotIndex = slotIndex;
        return this;
    }

    @CanIgnoreReturnValue
    @RequiresApi(value=33)
    public UiccCardInfoBuilder setPhysicalSlotIndex(int physicalSlotIndex) {
        this.physicalSlotIndex = physicalSlotIndex;
        return this;
    }

    @CanIgnoreReturnValue
    @RequiresApi(value=33)
    public UiccCardInfoBuilder setPorts(@NonNull List<UiccPortInfo> portList) {
        this.portList = portList;
        return this;
    }

    @CanIgnoreReturnValue
    @RequiresApi(value=33)
    public UiccCardInfoBuilder setIsMultipleEnabledProfilesSupported(boolean isMultipleEnabledProfilesSupported) {
        this.isMultipleEnabledProfilesSupported = isMultipleEnabledProfilesSupported;
        return this;
    }

    @CanIgnoreReturnValue
    public UiccCardInfoBuilder setIsEuicc(boolean isEuicc) {
        this.isEuicc = isEuicc;
        return this;
    }

    @CanIgnoreReturnValue
    public UiccCardInfoBuilder setIsRemovable(boolean isRemovable) {
        this.isRemovable = isRemovable;
        return this;
    }

    public UiccCardInfo build() {
        if (RuntimeEnvironment.getApiLevel() < 33) {
            return (UiccCardInfo)ReflectionHelpers.callConstructor(UiccCardInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isEuicc), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.cardId), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.eid), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.iccId), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.slotIndex), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isRemovable)});
        }
        return (UiccCardInfo)ReflectionHelpers.callConstructor(UiccCardInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isEuicc), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.cardId), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.eid), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.physicalSlotIndex), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isRemovable), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isMultipleEnabledProfilesSupported), ReflectionHelpers.ClassParameter.from(List.class, this.portList)});
    }
}

