/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.companion.virtual.IVirtualDeviceManager;
import android.companion.virtual.VirtualDevice;
import android.companion.virtual.VirtualDeviceManager;
import android.companion.virtual.VirtualDeviceParams;
import android.companion.virtual.sensor.VirtualSensor;
import android.companion.virtual.sensor.VirtualSensorCallback;
import android.companion.virtual.sensor.VirtualSensorDirectChannelCallback;
import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowVirtualSensor;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=VirtualDeviceManager.class, minSdk=34, isInAndroidSdk=false)
public class ShadowVirtualDeviceManager {
    private final List<VirtualDeviceManager.VirtualDevice> mVirtualDevices = new ArrayList<VirtualDeviceManager.VirtualDevice>();
    private Context context;
    private IVirtualDeviceManager service;

    @Implementation
    protected void __constructor__(IVirtualDeviceManager service, Context context) {
        this.context = context;
        this.service = service;
    }

    @Implementation
    protected VirtualDeviceManager.VirtualDevice createVirtualDevice(int associationId, VirtualDeviceParams params) {
        VirtualDeviceManager.VirtualDevice device = (VirtualDeviceManager.VirtualDevice)ReflectionHelpers.callConstructor(VirtualDeviceManager.VirtualDevice.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(IVirtualDeviceManager.class, (Object)this.service), ReflectionHelpers.ClassParameter.from(Context.class, (Object)this.context), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)associationId), ReflectionHelpers.ClassParameter.from(VirtualDeviceParams.class, (Object)params)});
        this.mVirtualDevices.add(device);
        return device;
    }

    @Implementation
    protected List<VirtualDevice> getVirtualDevices() {
        return this.mVirtualDevices.stream().map(virtualDevice -> new VirtualDevice(virtualDevice.getDeviceId(), ((ShadowVirtualDevice)Shadow.extract((Object)virtualDevice)).getParams().getName())).collect(Collectors.toList());
    }

    @Implementation
    protected int getDevicePolicy(int deviceId, int policyType) {
        return this.mVirtualDevices.stream().filter(virtualDevice -> virtualDevice.getDeviceId() == deviceId).findFirst().map(virtualDevice -> ((ShadowVirtualDevice)Shadow.extract((Object)virtualDevice)).getParams().getDevicePolicy(policyType)).orElse(0);
    }

    @Implementation
    protected boolean isValidVirtualDeviceId(int deviceId) {
        return this.mVirtualDevices.stream().anyMatch(virtualDevice -> virtualDevice.getDeviceId() == deviceId);
    }

    @Implements(value=VirtualDeviceManager.VirtualDevice.class, minSdk=34, isInAndroidSdk=false)
    public static class ShadowVirtualDevice {
        private static final AtomicInteger nextDeviceId = new AtomicInteger(1);
        @RealObject
        VirtualDeviceManager.VirtualDevice realVirtualDevice;
        private VirtualDeviceParams params;
        private int deviceId;
        private PendingIntent pendingIntent;
        private Integer pendingIntentResultCode = 0;

        @Implementation
        protected void __constructor__(IVirtualDeviceManager service, Context context, int associationId, VirtualDeviceParams params) {
            Shadow.invokeConstructor(VirtualDeviceManager.VirtualDevice.class, (Object)this.realVirtualDevice, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(IVirtualDeviceManager.class, (Object)service), ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)associationId), ReflectionHelpers.ClassParameter.from(VirtualDeviceParams.class, (Object)params)});
            this.params = params;
            this.deviceId = nextDeviceId.getAndIncrement();
        }

        @Implementation
        protected int getDeviceId() {
            return this.deviceId;
        }

        @Implementation
        protected void close() {
        }

        VirtualDeviceParams getParams() {
            return this.params;
        }

        @Implementation
        protected List<VirtualSensor> getVirtualSensorList() {
            if (this.params.getVirtualSensorConfigs() == null) {
                return new ArrayList<VirtualSensor>();
            }
            return this.params.getVirtualSensorConfigs().stream().map(config -> {
                VirtualSensor sensor = new VirtualSensor(config.hashCode(), config.getType(), config.getName(), null, null);
                ShadowVirtualSensor shadowSensor = (ShadowVirtualSensor)Shadow.extract((Object)sensor);
                shadowSensor.setDeviceId(this.deviceId);
                return sensor;
            }).collect(Collectors.toList());
        }

        @Implementation
        protected void launchPendingIntent(int displayId, PendingIntent pendingIntent, Executor executor, IntConsumer listener) {
            this.pendingIntent = pendingIntent;
            executor.execute(() -> listener.accept(this.pendingIntentResultCode));
        }

        public void setPendingIntentCallbackResultCode(int resultCode) {
            this.pendingIntentResultCode = resultCode;
        }

        public PendingIntent getLastLaunchedPendingIntent() {
            return this.pendingIntent;
        }

        public VirtualSensorCallback getVirtualSensorCallback() {
            return this.params.getVirtualSensorCallback() == null ? null : ((VirtualSensorCallbackDelegateReflector)Reflector.reflector(VirtualSensorCallbackDelegateReflector.class, (Object)this.params.getVirtualSensorCallback())).getCallback();
        }

        public VirtualSensorDirectChannelCallback getVirtualSensorDirectChannelCallback() {
            return this.params.getVirtualSensorCallback() == null ? null : ((VirtualSensorCallbackDelegateReflector)Reflector.reflector(VirtualSensorCallbackDelegateReflector.class, (Object)this.params.getVirtualSensorCallback())).getDirectChannelCallback();
        }

        @Resetter
        public static void reset() {
            nextDeviceId.set(1);
        }
    }

    @ForType(className="android.companion.virtual.VirtualDeviceParams$Builder$VirtualSensorCallbackDelegate")
    private static interface VirtualSensorCallbackDelegateReflector {
        @Accessor(value="mCallback")
        public VirtualSensorCallback getCallback();

        @Accessor(value="mDirectChannelCallback")
        public VirtualSensorDirectChannelCallback getDirectChannelCallback();
    }
}

