/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Trace;
import android.util.Log;
import com.google.auto.value.AutoValue;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.AutoValue_ShadowTrace_AsyncTraceSection;
import org.robolectric.shadows.AutoValue_ShadowTrace_Counter;

@Implements(value=Trace.class)
public class ShadowTrace {
    private static final String TAG = "ShadowTrace";
    private static final ThreadLocal<Deque<String>> currentSections = ThreadLocal.withInitial(() -> new ArrayDeque());
    private static final ThreadLocal<Queue<String>> previousSections = ThreadLocal.withInitial(() -> new ArrayDeque());
    private static final Set<AsyncTraceSection> currentAsyncSections = new HashSet<AsyncTraceSection>();
    private static final Set<AsyncTraceSection> previousAsyncSections = new HashSet<AsyncTraceSection>();
    private static final List<Counter> counters = new ArrayList<Counter>();
    private static final boolean CRASH_ON_INCORRECT_USAGE_DEFAULT = true;
    private static boolean crashOnIncorrectUsage = true;
    private static boolean isEnabled = true;
    private static final long TRACE_TAG_APP = 4096L;
    private static final int MAX_SECTION_NAME_LEN = 127;
    private static long tags = 4096L;

    @Implementation(minSdk=18)
    protected static void beginSection(String sectionName) {
        if (tags == 0L) {
            return;
        }
        if (!ShadowTrace.checkValidSectionName(sectionName)) {
            return;
        }
        currentSections.get().addFirst(sectionName);
    }

    @Implementation(minSdk=18)
    protected static void endSection() {
        if (tags == 0L) {
            return;
        }
        if (currentSections.get().isEmpty()) {
            Log.e((String)TAG, (String)"Trying to end a trace section that was never started");
            return;
        }
        previousSections.get().offer(currentSections.get().removeFirst());
    }

    @Implementation(minSdk=29)
    protected static synchronized void beginAsyncSection(String sectionName, int cookie) {
        if (tags == 0L) {
            return;
        }
        if (!ShadowTrace.checkValidSectionName(sectionName)) {
            return;
        }
        AsyncTraceSection newSection = AsyncTraceSection.newBuilder().setSectionName(sectionName).setCookie(cookie).build();
        if (currentAsyncSections.contains(newSection)) {
            if (crashOnIncorrectUsage) {
                throw new IllegalStateException("Section is already running");
            }
            Log.w((String)TAG, (String)"Section is already running");
            return;
        }
        currentAsyncSections.add(newSection);
    }

    @Implementation(minSdk=29)
    protected static synchronized void endAsyncSection(String sectionName, int cookie) {
        if (tags == 0L) {
            return;
        }
        AsyncTraceSection section = AsyncTraceSection.newBuilder().setSectionName(sectionName).setCookie(cookie).build();
        if (!currentAsyncSections.contains(section)) {
            Log.e((String)TAG, (String)"Trying to end a trace section that was never started");
            return;
        }
        currentAsyncSections.remove(section);
        previousAsyncSections.add(section);
    }

    @Implementation(minSdk=18)
    protected static long nativeGetEnabledTags() {
        return tags;
    }

    @Implementation(minSdk=18)
    protected static void setAppTracingAllowed(boolean appTracingAllowed) {
        tags = appTracingAllowed ? 4096L : 0L;
    }

    @Implementation(minSdk=29)
    protected static boolean isEnabled() {
        return isEnabled;
    }

    @Implementation(minSdk=29)
    protected static void setCounter(String counterName, long counterValue) {
        Verify.verifyNotNull((Object)counterName);
        counters.add(Counter.newBuilder().setName(counterName).setValue(counterValue).build());
    }

    public static void setEnabled(boolean enabled) {
        isEnabled = enabled;
    }

    public static Deque<String> getCurrentSections() {
        return new ArrayDeque<String>((Collection)currentSections.get());
    }

    public static Queue<String> getPreviousSections() {
        return new ArrayDeque<String>((Collection)previousSections.get());
    }

    public static ImmutableSet<AsyncTraceSection> getCurrentAsyncSections() {
        return ImmutableSet.copyOf(currentAsyncSections);
    }

    public static ImmutableSet<AsyncTraceSection> getPreviousAsyncSections() {
        return ImmutableSet.copyOf(previousAsyncSections);
    }

    public static ImmutableList<Counter> getCounters() {
        return ImmutableList.copyOf(counters);
    }

    public static void doNotUseSetCrashOnIncorrectUsage(boolean crashOnIncorrectUsage) {
        ShadowTrace.crashOnIncorrectUsage = crashOnIncorrectUsage;
    }

    private static boolean checkValidSectionName(String sectionName) {
        if (sectionName == null) {
            if (crashOnIncorrectUsage) {
                throw new NullPointerException("sectionName cannot be null");
            }
            Log.w((String)TAG, (String)"Section name cannot be null");
            return false;
        }
        if (sectionName.length() > 127) {
            if (crashOnIncorrectUsage) {
                throw new IllegalArgumentException("sectionName is too long");
            }
            Log.w((String)TAG, (String)"Section name is too long");
            return false;
        }
        return true;
    }

    @Resetter
    public static void reset() {
        currentSections.get().clear();
        previousSections.get().clear();
        currentAsyncSections.clear();
        previousAsyncSections.clear();
        counters.clear();
        isEnabled = true;
        crashOnIncorrectUsage = true;
    }

    @AutoValue
    public static abstract class AsyncTraceSection {
        public abstract String getSectionName();

        public abstract Integer getCookie();

        public static Builder newBuilder() {
            return new AutoValue_ShadowTrace_AsyncTraceSection.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setSectionName(String var1);

            public abstract Builder setCookie(Integer var1);

            public abstract AsyncTraceSection build();
        }
    }

    @AutoValue
    public static abstract class Counter {
        public abstract String getName();

        public abstract long getValue();

        public static Builder newBuilder() {
            return new AutoValue_ShadowTrace_Counter.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setName(String var1);

            public abstract Builder setValue(long var1);

            public abstract Counter build();
        }
    }
}

