/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.HardwareBuffer;
import android.os.Parcel;
import android.view.Surface;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.SurfaceNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowSurface;

@Implements(value=Surface.class, minSdk=26, shadowPicker=Picker.class, isInAndroidSdk=false)
public class ShadowNativeSurface {
    @Implementation
    protected static long nativeCreateFromSurfaceTexture(SurfaceTexture surfaceTexture) throws Surface.OutOfResourcesException {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return SurfaceNatives.nativeCreateFromSurfaceTexture((SurfaceTexture)surfaceTexture);
    }

    @Implementation
    protected static long nativeCreateFromSurfaceControl(long surfaceControlNativeObject) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return SurfaceNatives.nativeCreateFromSurfaceControl((long)surfaceControlNativeObject);
    }

    @Implementation(minSdk=29)
    protected static long nativeGetFromSurfaceControl(long surfaceObject, long surfaceControlNativeObject) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return SurfaceNatives.nativeGetFromSurfaceControl((long)surfaceObject, (long)surfaceControlNativeObject);
    }

    @Implementation(minSdk=31)
    protected static long nativeGetFromBlastBufferQueue(long surfaceObject, long blastBufferQueueNativeObject) {
        return SurfaceNatives.nativeGetFromBlastBufferQueue((long)surfaceObject, (long)blastBufferQueueNativeObject);
    }

    @Implementation
    protected static long nativeLockCanvas(long nativeObject, Canvas canvas, Rect dirty) throws Surface.OutOfResourcesException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Implementation
    protected static void nativeUnlockCanvasAndPost(long nativeObject, Canvas canvas) {
        SurfaceNatives.nativeUnlockCanvasAndPost((long)nativeObject, (Canvas)canvas);
    }

    @Implementation
    protected static void nativeRelease(long nativeObject) {
        SurfaceNatives.nativeRelease((long)nativeObject);
    }

    @Implementation
    protected static boolean nativeIsValid(long nativeObject) {
        return SurfaceNatives.nativeIsValid((long)nativeObject);
    }

    @Implementation
    protected static boolean nativeIsConsumerRunningBehind(long nativeObject) {
        return SurfaceNatives.nativeIsConsumerRunningBehind((long)nativeObject);
    }

    @Implementation
    protected static long nativeReadFromParcel(long nativeObject, Parcel source) {
        return SurfaceNatives.nativeReadFromParcel((long)nativeObject, (Parcel)source);
    }

    @Implementation
    protected static void nativeWriteToParcel(long nativeObject, Parcel dest) {
        SurfaceNatives.nativeWriteToParcel((long)nativeObject, (Parcel)dest);
    }

    @Implementation
    protected static void nativeAllocateBuffers(long nativeObject) {
        SurfaceNatives.nativeAllocateBuffers((long)nativeObject);
    }

    @Implementation
    protected static int nativeGetWidth(long nativeObject) {
        return SurfaceNatives.nativeGetWidth((long)nativeObject);
    }

    @Implementation
    protected static int nativeGetHeight(long nativeObject) {
        return SurfaceNatives.nativeGetHeight((long)nativeObject);
    }

    @Implementation
    protected static long nativeGetNextFrameNumber(long nativeObject) {
        return SurfaceNatives.nativeGetNextFrameNumber((long)nativeObject);
    }

    @Implementation
    protected static int nativeSetScalingMode(long nativeObject, int scalingMode) {
        return SurfaceNatives.nativeSetScalingMode((long)nativeObject, (int)scalingMode);
    }

    @Implementation
    protected static int nativeForceScopedDisconnect(long nativeObject) {
        return SurfaceNatives.nativeForceScopedDisconnect((long)nativeObject);
    }

    @Implementation(minSdk=31)
    protected static int nativeAttachAndQueueBufferWithColorSpace(long nativeObject, HardwareBuffer buffer, int colorSpaceId) {
        return SurfaceNatives.nativeAttachAndQueueBufferWithColorSpace((long)nativeObject, (HardwareBuffer)buffer, (int)colorSpaceId);
    }

    @Implementation(minSdk=27)
    protected static int nativeSetSharedBufferModeEnabled(long nativeObject, boolean enabled) {
        return SurfaceNatives.nativeSetSharedBufferModeEnabled((long)nativeObject, (boolean)enabled);
    }

    @Implementation(minSdk=27)
    protected static int nativeSetAutoRefreshEnabled(long nativeObject, boolean enabled) {
        return SurfaceNatives.nativeSetAutoRefreshEnabled((long)nativeObject, (boolean)enabled);
    }

    @Implementation(minSdk=31)
    protected static int nativeSetFrameRate(long nativeObject, float frameRate, int compatibility, int changeFrameRateStrategy) {
        return SurfaceNatives.nativeSetFrameRate((long)nativeObject, (float)frameRate, (int)compatibility, (int)changeFrameRateStrategy);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowSurface.class, ShadowNativeSurface.class);
        }
    }
}

