/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import libcore.util.NativeAllocationRegistry;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.nativeruntime.NativeAllocationRegistryNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowNoopNativeAllocationRegistry;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=NativeAllocationRegistry.class, minSdk=26, isInAndroidSdk=false, shadowPicker=Picker.class)
public class ShadowNativeAllocationRegistry {
    @RealObject
    protected NativeAllocationRegistry realNativeAllocationRegistry;

    @Implementation
    protected Runnable registerNativeAllocation(Object referent, long nativePtr) {
        if (nativePtr != 0L && this.hasValidFreeFunction()) {
            return ((NativeAllocationRegistryReflector)Reflector.reflector(NativeAllocationRegistryReflector.class, (Object)this.realNativeAllocationRegistry)).registerNativeAllocation(referent, nativePtr);
        }
        return () -> {};
    }

    private boolean hasValidFreeFunction() {
        return ((NativeAllocationRegistryReflector)Reflector.reflector(NativeAllocationRegistryReflector.class, (Object)this.realNativeAllocationRegistry)).getFreeFunction() != 0L;
    }

    @Implementation
    protected static void applyFreeFunction(long freeFunction, long nativePtr) {
        NativeAllocationRegistryNatives.applyFreeFunction((long)freeFunction, (long)nativePtr);
    }

    @ForType(value=NativeAllocationRegistry.class)
    static interface NativeAllocationRegistryReflector {
        @Direct
        public Runnable registerNativeAllocation(Object var1, long var2);

        @Accessor(value="freeFunction")
        public long getFreeFunction();
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowNoopNativeAllocationRegistry.class, ShadowNativeAllocationRegistry.class);
        }
    }
}

