/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.telecom.Call;
import android.telecom.CallAudioState;
import android.telecom.InCallAdapter;
import android.telecom.InCallService;
import android.telecom.ParcelableCall;
import android.telecom.Phone;
import com.android.internal.os.SomeArgs;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowPhone;
import org.robolectric.shadows.ShadowService;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=InCallService.class, minSdk=23)
public class ShadowInCallService
extends ShadowService {
    @RealObject
    private InCallService inCallService;
    private static final int MSG_ADD_CALL = 2;
    private static final int MSG_SET_POST_DIAL_WAIT = 4;
    private static final int MSG_ON_CONNECTION_EVENT = 9;
    private ShadowPhone shadowPhone;
    private boolean canAddCall;
    private boolean muted;
    private int audioRoute = 1;
    private BluetoothDevice bluetoothDevice;
    private int supportedRouteMask;

    @Implementation
    protected void __constructor__() {
        InCallAdapter adapter = (InCallAdapter)Shadow.newInstanceOf(InCallAdapter.class);
        Phone phone = Build.VERSION.SDK_INT > 25 ? (Phone)ReflectionHelpers.callConstructor(Phone.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(InCallAdapter.class, (Object)adapter), ReflectionHelpers.ClassParameter.from(String.class, (Object)""), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)}) : (Phone)ReflectionHelpers.callConstructor(Phone.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(InCallAdapter.class, (Object)adapter)});
        this.shadowPhone = (ShadowPhone)Shadow.extract((Object)phone);
        ReflectionHelpers.setField((Object)this.inCallService, (String)"mPhone", (Object)phone);
        Shadow.invokeConstructor(InCallService.class, (Object)this.inCallService, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public void addCall(Call call) {
        this.shadowPhone.addCall(call);
    }

    public void addCall(ParcelableCall parcelableCall) {
        this.getHandler().obtainMessage(2, (Object)parcelableCall).sendToTarget();
    }

    public void setPostDialWait(String callId, String remaining) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = callId;
        args.arg2 = remaining;
        this.getHandler().obtainMessage(4, (Object)args).sendToTarget();
    }

    public void onConnectionEvent(String callId, String event, Bundle extras) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = callId;
        args.arg2 = event;
        args.arg3 = extras;
        this.getHandler().obtainMessage(9, (Object)args).sendToTarget();
    }

    public void removeCall(Call call) {
        this.shadowPhone.removeCall(call);
    }

    @Implementation
    protected boolean canAddCall() {
        return this.canAddCall;
    }

    public void setCanAddCall(boolean canAddCall) {
        this.canAddCall = canAddCall;
    }

    @Implementation
    protected void setMuted(boolean muted) {
        this.muted = muted;
        if (this.isInCallAdapterSet()) {
            ((ReflectorInCallService)Reflector.reflector(ReflectorInCallService.class, (Object)this.inCallService)).setMuted(muted);
        }
    }

    @Implementation
    protected void setAudioRoute(int audioRoute) {
        this.audioRoute = audioRoute;
        if (this.isInCallAdapterSet()) {
            ((ReflectorInCallService)Reflector.reflector(ReflectorInCallService.class, (Object)this.inCallService)).setAudioRoute(audioRoute);
        }
    }

    @Implementation
    protected CallAudioState getCallAudioState() {
        if (this.isInCallAdapterSet()) {
            return ((ReflectorInCallService)Reflector.reflector(ReflectorInCallService.class, (Object)this.inCallService)).getCallAudioState();
        }
        return new CallAudioState(this.muted, this.audioRoute, this.supportedRouteMask);
    }

    public void setSupportedRouteMask(int mask) {
        this.supportedRouteMask = mask;
    }

    @Implementation(minSdk=28)
    protected void requestBluetoothAudio(BluetoothDevice bluetoothDevice) {
        this.bluetoothDevice = bluetoothDevice;
        if (this.isInCallAdapterSet()) {
            ((ReflectorInCallService)Reflector.reflector(ReflectorInCallService.class, (Object)this.inCallService)).requestBluetoothAudio(bluetoothDevice);
        }
    }

    @TargetApi(value=28)
    public BluetoothDevice getBluetoothAudio() {
        return this.bluetoothDevice;
    }

    private Handler getHandler() {
        return ((ReflectorInCallService)Reflector.reflector(ReflectorInCallService.class, (Object)this.inCallService)).getHandler();
    }

    private boolean isInCallAdapterSet() {
        Phone phone = ((ReflectorInCallService)Reflector.reflector(ReflectorInCallService.class, (Object)this.inCallService)).getPhone();
        InCallAdapter inCallAdapter = ((ReflectorPhone)Reflector.reflector(ReflectorPhone.class, (Object)phone)).getInCallAdapter();
        Object internalAdapter = ((ReflectorInCallAdapter)Reflector.reflector(ReflectorInCallAdapter.class, (Object)inCallAdapter)).getInternalInCallAdapter();
        return internalAdapter != null;
    }

    @ForType(value=InCallService.class)
    static interface ReflectorInCallService {
        @Accessor(value="mHandler")
        public Handler getHandler();

        @Accessor(value="mPhone")
        public Phone getPhone();

        @Direct
        public void requestBluetoothAudio(BluetoothDevice var1);

        @Direct
        public void setAudioRoute(int var1);

        @Direct
        public void setMuted(boolean var1);

        @Direct
        public CallAudioState getCallAudioState();
    }

    @ForType(value=Phone.class)
    static interface ReflectorPhone {
        @Accessor(value="mInCallAdapter")
        public InCallAdapter getInCallAdapter();
    }

    @ForType(value=InCallAdapter.class)
    static interface ReflectorInCallAdapter {
        @Accessor(value="mAdapter")
        public Object getInternalInCallAdapter();
    }
}

