/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ImageReader.class, looseSignatures=true)
public class ShadowImageReader {
    private static final int ACQUIRE_SUCCESS = 0;
    private static final int ACQUIRE_NO_BUFS = 1;
    private static final int ACQUIRE_MAX_IMAGES = 2;
    private final AtomicLong imageCount = new AtomicLong(0L);
    private final AtomicBoolean readerValid = new AtomicBoolean(true);
    private final AtomicLong availableBuffers = new AtomicLong(0L);
    private final List<Image> openedImages = new ArrayList<Image>();
    private Surface surface;
    @RealObject
    private ImageReader imageReader;
    private Canvas canvas;

    @Implementation(minSdk=19)
    protected void close() {
        this.readerValid.set(false);
        this.openedImages.clear();
    }

    @Implementation(minSdk=19, maxSdk=32)
    protected int nativeImageSetup(Image image) {
        if (!this.readerValid.get()) {
            throw new IllegalStateException("ImageReader closed.");
        }
        if (this.openedImages.size() >= this.imageReader.getMaxImages()) {
            return 2;
        }
        if (this.availableBuffers.get() == 0L) {
            return 1;
        }
        this.availableBuffers.getAndDecrement();
        this.openedImages.add(image);
        ShadowSurfaceImage shadowSurfaceImage = (ShadowSurfaceImage)Shadow.extract((Object)image);
        shadowSurfaceImage.setTimeStamp(this.imageCount.get());
        return 0;
    }

    @Implementation(minSdk=33, maxSdk=33)
    protected int nativeImageSetup(Image image, boolean useLegacyImageFormat) {
        return this.nativeImageSetup(image);
    }

    @Implementation(minSdk=34)
    protected int nativeImageSetup(Object image) {
        return this.nativeImageSetup((Image)image);
    }

    @Implementation(minSdk=19)
    protected void nativeReleaseImage(Image i) {
        this.openedImages.remove(i);
    }

    @Implementation(minSdk=19)
    protected Surface nativeGetSurface() {
        if (this.surface == null) {
            this.surface = new FakeSurface();
        }
        return this.surface;
    }

    @Implements(className="android.media.ImageReader$SurfaceImage")
    public static class ShadowSurfaceImage {
        @RealObject
        Object surfaceImage;

        @Implementation(minSdk=19)
        protected int getWidth() {
            ImageReader reader = (ImageReader)ReflectionHelpers.getField((Object)this.surfaceImage, (String)"this$0");
            return reader.getWidth();
        }

        @Implementation(minSdk=19)
        protected int getHeight() {
            ImageReader reader = (ImageReader)ReflectionHelpers.getField((Object)this.surfaceImage, (String)"this$0");
            return reader.getHeight();
        }

        @Implementation(minSdk=19)
        protected int getFormat() {
            ImageReader reader = (ImageReader)ReflectionHelpers.getField((Object)this.surfaceImage, (String)"this$0");
            return reader.getImageFormat();
        }

        public void setTimeStamp(long timestamp) {
            ReflectionHelpers.setField((Object)this.surfaceImage, (String)"mTimestamp", (Object)timestamp);
        }
    }

    private class FakeSurface
    extends Surface {
        public Canvas lockCanvas(Rect inOutDirty) {
            if (ShadowImageReader.this.canvas == null) {
                ShadowImageReader.this.canvas = new Canvas();
            }
            return ShadowImageReader.this.canvas;
        }

        public Canvas lockHardwareCanvas() {
            if (ShadowImageReader.this.canvas == null) {
                ShadowImageReader.this.canvas = new Canvas();
            }
            return ShadowImageReader.this.canvas;
        }

        public void unlockCanvasAndPost(Canvas canvas) {
            ShadowImageReader.this.availableBuffers.getAndIncrement();
            ShadowImageReader.this.imageCount.getAndIncrement();
            ImageReader.OnImageAvailableListener listener = ((ImageReaderReflector)Reflector.reflector(ImageReaderReflector.class, (Object)ShadowImageReader.this.imageReader)).getListener();
            Handler handler = ((ImageReaderReflector)Reflector.reflector(ImageReaderReflector.class, (Object)ShadowImageReader.this.imageReader)).getListenerHandler();
            if (listener == null) {
                return;
            }
            if (handler == null) {
                Objects.requireNonNull(listener).onImageAvailable(ShadowImageReader.this.imageReader);
                return;
            }
            Objects.requireNonNull(handler).post(() -> Objects.requireNonNull(listener).onImageAvailable(ShadowImageReader.this.imageReader));
        }
    }

    @ForType(value=ImageReader.class)
    static interface ImageReaderReflector {
        @Accessor(value="mListener")
        public ImageReader.OnImageAvailableListener getListener();

        @Accessor(value="mListenerHandler")
        public Handler getListenerHandler();
    }
}

