/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.Camera;
import android.os.Build;
import android.view.SurfaceHolder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Camera.class)
public class ShadowCamera {
    private static final ImmutableMap<String, String> DEFAULT_PARAMS = ImmutableMap.builder().put((Object)"picture-size", (Object)"1280x960").put((Object)"preview-size", (Object)"640x480").put((Object)"preview-fps-range", (Object)"10,30").put((Object)"preview-frame-rate", (Object)"30").put((Object)"preview-format", (Object)"yuv420sp").put((Object)"picture-format-values", (Object)"yuv420sp,jpeg").put((Object)"preview-format-values", (Object)"yuv420sp,jpeg").put((Object)"picture-size-values", (Object)"320x240,640x480,800x600").put((Object)"preview-size-values", (Object)"320x240,640x480").put((Object)"preview-fps-range-values", (Object)"(15000,15000),(10000,30000)").put((Object)"preview-frame-rate-values", (Object)"10,15,30").put((Object)"exposure-compensation", (Object)"0").put((Object)"exposure-compensation-step", (Object)"0.5").put((Object)"min-exposure-compensation", (Object)"-6").put((Object)"max-exposure-compensation", (Object)"6").put((Object)"focus-mode-values", (Object)"auto").put((Object)"focus-mode", (Object)"auto").put((Object)"flash-mode-values", (Object)"auto,on,off").put((Object)"flash-mode", (Object)"auto").put((Object)"max-num-focus-areas", (Object)"1").put((Object)"max-num-metering-areas", (Object)"1").build();
    private static int lastOpenedCameraId;
    private int id;
    private boolean locked = true;
    private boolean previewing;
    private boolean released;
    private Camera.Parameters parameters;
    private Camera.PreviewCallback previewCallback;
    private List<byte[]> callbackBuffers = new ArrayList<byte[]>();
    private SurfaceHolder surfaceHolder;
    private int displayOrientation;
    private Camera.AutoFocusCallback autoFocusCallback;
    private boolean autoFocusing;
    private boolean shutterSoundEnabled = true;
    private static final Map<Integer, Camera.CameraInfo> cameras;
    private static final Map<Integer, Camera.Parameters> cameraParameters;
    @RealObject
    private Camera realCamera;

    @Implementation
    protected static Camera open() {
        return ShadowCamera.open(0);
    }

    @Implementation
    protected static Camera open(int cameraId) {
        lastOpenedCameraId = cameraId;
        Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
        ShadowCamera shadowCamera = (ShadowCamera)Shadow.extract((Object)camera);
        shadowCamera.id = cameraId;
        if (cameraParameters.containsKey(cameraId)) {
            shadowCamera.parameters = cameraParameters.get(cameraId);
        } else {
            cameraParameters.put(cameraId, camera.getParameters());
        }
        return camera;
    }

    public static int getLastOpenedCameraId() {
        return lastOpenedCameraId;
    }

    @Implementation
    protected void unlock() {
        this.locked = false;
    }

    @Implementation
    protected void reconnect() {
        this.locked = true;
    }

    @Implementation
    protected Camera.Parameters getParameters() {
        if (this.parameters == null) {
            this.parameters = (Camera.Parameters)ReflectionHelpers.callConstructor(Camera.Parameters.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Camera.class, (Object)this.realCamera)});
            Joiner.MapJoiner mapJoiner = Joiner.on((String)";").withKeyValueSeparator("=");
            this.parameters.unflatten(mapJoiner.join(DEFAULT_PARAMS));
        }
        return this.parameters;
    }

    @Implementation
    protected void setParameters(Camera.Parameters params) {
        this.parameters = params;
    }

    @Implementation
    protected void setPreviewDisplay(SurfaceHolder holder) {
        this.surfaceHolder = holder;
    }

    @Implementation
    protected void startPreview() {
        this.previewing = true;
    }

    @Implementation
    protected void stopPreview() {
        this.previewing = false;
    }

    @Implementation
    protected void release() {
        this.released = true;
    }

    @Implementation
    protected void setPreviewCallback(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    @Implementation
    protected void setOneShotPreviewCallback(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    @Implementation
    protected void setPreviewCallbackWithBuffer(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    public void invokePreviewCallback(byte[] data) {
        if (this.previewCallback != null) {
            this.previewCallback.onPreviewFrame(data, this.realCamera);
        }
    }

    @Implementation
    protected void addCallbackBuffer(byte[] callbackBuffer) {
        this.callbackBuffers.add(callbackBuffer);
    }

    public List<byte[]> getAddedCallbackBuffers() {
        return Collections.unmodifiableList(this.callbackBuffers);
    }

    @Implementation
    protected void setDisplayOrientation(int degrees) {
        this.displayOrientation = degrees;
        if (cameras.containsKey(this.id)) {
            ShadowCamera.cameras.get((Object)Integer.valueOf((int)this.id)).orientation = degrees;
        }
    }

    public int getDisplayOrientation() {
        return this.displayOrientation;
    }

    @Implementation
    protected void autoFocus(Camera.AutoFocusCallback callback) {
        this.autoFocusCallback = callback;
        this.autoFocusing = true;
    }

    @Implementation
    protected void cancelAutoFocus() {
        this.autoFocusCallback = null;
        this.autoFocusing = false;
    }

    public boolean hasRequestedAutoFocus() {
        return this.autoFocusing;
    }

    public void invokeAutoFocusCallback(boolean success, Camera camera) {
        if (this.autoFocusCallback == null) {
            throw new IllegalStateException("cannot invoke AutoFocusCallback before autoFocus() has been called or after cancelAutoFocus() has been called or after the callback has been invoked.");
        }
        this.autoFocusCallback.onAutoFocus(success, camera);
        this.autoFocusCallback = null;
        this.autoFocusing = false;
    }

    @Implementation
    protected static void getCameraInfo(int cameraId, Camera.CameraInfo cameraInfo) {
        Camera.CameraInfo foundCam = cameras.get(cameraId);
        cameraInfo.facing = foundCam.facing;
        cameraInfo.orientation = foundCam.orientation;
        if (Build.VERSION.SDK_INT >= 17) {
            cameraInfo.canDisableShutterSound = foundCam.canDisableShutterSound;
        }
    }

    @Implementation
    protected static int getNumberOfCameras() {
        return cameras.size();
    }

    @Implementation
    protected void takePicture(Camera.ShutterCallback shutter, Camera.PictureCallback raw, Camera.PictureCallback jpeg) {
        if (shutter != null) {
            shutter.onShutter();
        }
        if (raw != null) {
            raw.onPictureTaken(new byte[0], this.realCamera);
        }
        if (jpeg != null) {
            jpeg.onPictureTaken(new byte[0], this.realCamera);
        }
    }

    @Implementation(minSdk=17)
    protected boolean enableShutterSound(boolean enabled) {
        if (!enabled && cameras.containsKey(this.id) && !ShadowCamera.cameras.get((Object)Integer.valueOf((int)this.id)).canDisableShutterSound) {
            return false;
        }
        this.shutterSoundEnabled = enabled;
        return true;
    }

    public boolean isShutterSoundEnabled() {
        return this.shutterSoundEnabled;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isPreviewing() {
        return this.previewing;
    }

    public boolean isReleased() {
        return this.released;
    }

    public SurfaceHolder getPreviewDisplay() {
        return this.surfaceHolder;
    }

    public static void addCameraInfo(int id2, Camera.CameraInfo camInfo) {
        cameras.put(id2, camInfo);
    }

    @Resetter
    public static void clearCameraInfo() {
        cameras.clear();
        cameraParameters.clear();
    }

    static {
        cameras = new HashMap<Integer, Camera.CameraInfo>();
        cameraParameters = new HashMap<Integer, Camera.Parameters>();
    }

    @Implements(value=Camera.Parameters.class)
    public static class ShadowParameters {
        @RealObject
        private Camera.Parameters realParameters;

        public void initSupportedPreviewSizes() {
            this.realParameters.remove("preview-size-values");
        }

        public void setSupportedFocusModes(String ... focusModes) {
            this.realParameters.set("focus-mode-values", Joiner.on((String)",").join((Object[])focusModes));
            if (focusModes.length == 0) {
                this.realParameters.remove("focus-mode");
            }
        }

        public void setSupportedFlashModes(String ... flashModes) {
            this.realParameters.set("flash-mode-values", Joiner.on((String)",").join((Object[])flashModes));
            if (flashModes.length == 0) {
                this.realParameters.remove("flash-mode");
            }
        }

        public void setMaxNumFocusAreas(int maxNumFocusAreas) {
            this.realParameters.set("max-num-focus-areas", maxNumFocusAreas);
        }

        public void addSupportedPreviewSize(int width, int height) {
            ArrayList<String> sizesStrings = new ArrayList<String>();
            List sizes = this.realParameters.getSupportedPreviewSizes();
            if (sizes == null) {
                sizes = ImmutableList.of();
            }
            for (Camera.Size size : sizes) {
                sizesStrings.add(size.width + "x" + size.height);
            }
            sizesStrings.add(width + "x" + height);
            this.realParameters.set("preview-size-values", Joiner.on((String)",").join(sizesStrings));
        }

        public void setMaxNumMeteringAreas(int maxNumMeteringAreas) {
            this.realParameters.set("max-num-metering-areas", maxNumMeteringAreas);
        }

        public int getPreviewWidth() {
            return this.realParameters.getPreviewSize().width;
        }

        public int getPreviewHeight() {
            return this.realParameters.getPreviewSize().height;
        }

        public int getPictureWidth() {
            return this.realParameters.getPictureSize().width;
        }

        public int getPictureHeight() {
            return this.realParameters.getPictureSize().height;
        }

        public int getRotation() {
            return this.realParameters.getInt("rotation");
        }
    }
}

