/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android;

import android.app.WindowConfiguration;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import com.google.common.base.Strings;
import java.util.Locale;
import org.robolectric.res.Qualifiers;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.util.ReflectionHelpers;

public class DeviceConfig {
    public static final int DEFAULT_DENSITY = 160;
    public static final ScreenSize DEFAULT_SCREEN_SIZE = ScreenSize.normal;

    private DeviceConfig() {
    }

    static void applyToConfiguration(Qualifiers qualifiers, int apiLevel, Configuration configuration, DisplayMetrics displayMetrics) {
        ResTable_config resTab = qualifiers.getConfig();
        if (resTab.mcc != 0) {
            configuration.mcc = resTab.mcc;
        }
        if (resTab.mnc != 0) {
            configuration.mnc = resTab.mnc;
        }
        int screenLayoutSize = DeviceConfig.getScreenLayoutSize(configuration);
        int resTabSize = resTab.screenLayoutSize();
        if (resTabSize != 0) {
            screenLayoutSize = resTabSize;
            if (resTab.screenWidthDp == 0) {
                configuration.screenWidthDp = 0;
            }
            if (resTab.screenHeightDp == 0) {
                configuration.screenHeightDp = 0;
            }
        }
        int screenLayoutLong = DeviceConfig.getScreenLayoutLong(configuration);
        int resTabLong = resTab.screenLayoutLong();
        if (resTabLong != 0) {
            screenLayoutLong = resTabLong;
        }
        int screenLayoutLayoutDir = DeviceConfig.getScreenLayoutLayoutDir(configuration);
        int resTabLayoutDir = resTab.screenLayoutDirection();
        if (resTabLayoutDir != 0) {
            screenLayoutLayoutDir = resTabLayoutDir;
        }
        int screenLayoutRound = DeviceConfig.getScreenLayoutRound(configuration);
        int resTabRound = resTab.screenLayoutRound();
        if (resTabRound != 0) {
            screenLayoutRound = resTabRound << 8;
        }
        configuration.screenLayout = screenLayoutSize | screenLayoutLong | screenLayoutLayoutDir | screenLayoutRound;
        String lang = resTab.languageString();
        String region = resTab.regionString();
        String script = resTab.scriptString();
        Locale locale = Strings.isNullOrEmpty((String)lang) && Strings.isNullOrEmpty((String)region) && Strings.isNullOrEmpty((String)script) ? null : new Locale.Builder().setLanguage(lang).setRegion(region).setScript(script == null ? "" : script).build();
        if (locale != null) {
            DeviceConfig.setLocale(apiLevel, configuration, locale);
        }
        if (resTab.smallestScreenWidthDp != 0) {
            configuration.smallestScreenWidthDp = resTab.smallestScreenWidthDp;
        }
        if (resTab.screenWidthDp != 0) {
            configuration.screenWidthDp = resTab.screenWidthDp;
        }
        if (resTab.screenHeightDp != 0) {
            configuration.screenHeightDp = resTab.screenHeightDp;
        }
        if (resTab.orientation != 0) {
            configuration.orientation = resTab.orientation;
        }
        int uiModeType = DeviceConfig.getUiModeType(configuration);
        int resTabType = resTab.uiModeType();
        if (resTabType != 0) {
            uiModeType = resTabType;
        }
        int uiModeNight = DeviceConfig.getUiModeNight(configuration);
        int resTabNight = resTab.uiModeNight();
        if (resTabNight != 0) {
            uiModeNight = resTabNight;
        }
        configuration.uiMode = uiModeType | uiModeNight;
        if (resTab.density != 0) {
            DeviceConfig.setDensity(resTab.density, apiLevel, configuration, displayMetrics);
        }
        DeviceConfig.setDimensions(apiLevel, configuration, displayMetrics);
        if (resTab.touchscreen != 0) {
            configuration.touchscreen = resTab.touchscreen;
        }
        if (resTab.keyboard != 0) {
            configuration.keyboard = resTab.keyboard;
        }
        if (resTab.keyboardHidden() != 0) {
            configuration.keyboardHidden = resTab.keyboardHidden();
        }
        if (resTab.navigation != 0) {
            configuration.navigation = resTab.navigation;
        }
        if (resTab.navigationHidden() != 0) {
            configuration.navigationHidden = resTab.navigationHidden();
        }
        if (apiLevel >= 26) {
            if (resTab.colorModeWideColorGamut() != 0) {
                DeviceConfig.setColorModeGamut(configuration, resTab.colorMode & 3);
            }
            if (resTab.colorModeHdr() != 0) {
                DeviceConfig.setColorModeHdr(configuration, resTab.colorMode & 0xC);
            }
        }
    }

    private static void setDensity(int densityDpi, int apiLevel, Configuration configuration, DisplayMetrics displayMetrics) {
        if (apiLevel >= 17) {
            configuration.densityDpi = densityDpi;
        }
        displayMetrics.densityDpi = densityDpi;
        displayMetrics.density = (float)displayMetrics.densityDpi * 0.00625f;
        displayMetrics.xdpi = displayMetrics.noncompatXdpi = (float)displayMetrics.densityDpi;
        displayMetrics.ydpi = displayMetrics.noncompatYdpi = (float)displayMetrics.densityDpi;
    }

    private static void setDimensions(int apiLevel, Configuration configuration, DisplayMetrics displayMetrics) {
        int widthPx = (int)((float)configuration.screenWidthDp * displayMetrics.density);
        int heightPx = (int)((float)configuration.screenHeightDp * displayMetrics.density);
        displayMetrics.widthPixels = displayMetrics.noncompatWidthPixels = widthPx;
        displayMetrics.heightPixels = displayMetrics.noncompatHeightPixels = heightPx;
        if (apiLevel >= 28) {
            Rect bounds = new Rect(0, 0, widthPx, heightPx);
            WindowConfiguration windowConfiguration = (WindowConfiguration)ReflectionHelpers.getField((Object)configuration, (String)"windowConfiguration");
            windowConfiguration.setBounds(bounds);
            windowConfiguration.setAppBounds(bounds);
        }
    }

    static void applyRules(Configuration configuration, DisplayMetrics displayMetrics, int apiLevel) {
        ScreenSize requestedScreenSize;
        String language;
        Locale locale = DeviceConfig.getLocale(configuration, apiLevel);
        String string2 = language = locale == null ? "" : locale.getLanguage();
        if (language.isEmpty()) {
            String country;
            language = "en";
            String string3 = country = locale == null ? "" : locale.getCountry();
            if (country.isEmpty()) {
                country = "us";
            }
            locale = new Locale(language, country);
            DeviceConfig.setLocale(apiLevel, configuration, locale);
        }
        if (apiLevel <= 16 && DeviceConfig.getScreenLayoutLayoutDir(configuration) == 0) {
            DeviceConfig.setScreenLayoutLayoutDir(configuration, 64);
        }
        if ((requestedScreenSize = DeviceConfig.getScreenSize(configuration)) == null) {
            requestedScreenSize = DEFAULT_SCREEN_SIZE;
        }
        if (configuration.orientation == 0 && configuration.screenWidthDp != 0 && configuration.screenHeightDp != 0) {
            int n = configuration.orientation = configuration.screenWidthDp > configuration.screenHeightDp ? 2 : 1;
        }
        if (configuration.screenWidthDp == 0) {
            configuration.screenWidthDp = requestedScreenSize.width;
        }
        if (configuration.screenHeightDp == 0) {
            configuration.screenHeightDp = requestedScreenSize.height;
            if ((configuration.screenLayout & 0x30) == 32) {
                configuration.screenHeightDp = (int)((float)configuration.screenHeightDp * 1.25f);
            }
        }
        int lesserDimenPx = Math.min(configuration.screenWidthDp, configuration.screenHeightDp);
        int greaterDimenPx = Math.max(configuration.screenWidthDp, configuration.screenHeightDp);
        if (configuration.smallestScreenWidthDp == 0) {
            configuration.smallestScreenWidthDp = lesserDimenPx;
        }
        if (DeviceConfig.getScreenLayoutSize(configuration) == 0) {
            ScreenSize screenSize = ScreenSize.match(configuration.screenWidthDp, configuration.screenHeightDp);
            DeviceConfig.setScreenLayoutSize(configuration, screenSize.configValue);
        }
        if (DeviceConfig.getScreenLayoutLong(configuration) == 0) {
            DeviceConfig.setScreenLayoutLong(configuration, (double)((float)greaterDimenPx / (float)lesserDimenPx) >= 1.75 ? 32 : 16);
        }
        if (DeviceConfig.getScreenLayoutRound(configuration) == 0) {
            DeviceConfig.setScreenLayoutRound(configuration, 256);
        }
        if (configuration.orientation == 0) {
            configuration.orientation = configuration.screenWidthDp > configuration.screenHeightDp ? 2 : 1;
        } else if (configuration.orientation == 1 && configuration.screenWidthDp > configuration.screenHeightDp) {
            DeviceConfig.swapXY(configuration);
        } else if (configuration.orientation == 2 && configuration.screenWidthDp < configuration.screenHeightDp) {
            DeviceConfig.swapXY(configuration);
        }
        if (DeviceConfig.getUiModeType(configuration) == 0) {
            DeviceConfig.setUiModeType(configuration, 1);
        }
        if (DeviceConfig.getUiModeNight(configuration) == 0) {
            DeviceConfig.setUiModeNight(configuration, 16);
        }
        switch (displayMetrics.densityDpi) {
            case 65534: {
                throw new IllegalArgumentException("'anydpi' isn't actually a dpi");
            }
            case 65535: {
                throw new IllegalArgumentException("'nodpi' isn't actually a dpi");
            }
            case 0: {
                DeviceConfig.setDensity(160, apiLevel, configuration, displayMetrics);
            }
        }
        DeviceConfig.setDimensions(apiLevel, configuration, displayMetrics);
        if (configuration.touchscreen == 0) {
            configuration.touchscreen = 3;
        }
        if (configuration.keyboardHidden == 0) {
            configuration.keyboardHidden = 3;
        }
        if (configuration.keyboard == 0) {
            configuration.keyboard = 1;
        }
        if (configuration.navigationHidden == 0) {
            configuration.navigationHidden = 2;
        }
        if (configuration.navigation == 0) {
            configuration.navigation = 1;
        }
        if (apiLevel >= 26) {
            if (DeviceConfig.getColorModeGamut(configuration) == 0) {
                DeviceConfig.setColorModeGamut(configuration, 1);
            }
            if (DeviceConfig.getColorModeHdr(configuration) == 0) {
                DeviceConfig.setColorModeHdr(configuration, 4);
            }
        }
    }

    public static ScreenSize getScreenSize(Configuration configuration) {
        return ScreenSize.find(DeviceConfig.getScreenLayoutSize(configuration));
    }

    private static void swapXY(Configuration configuration) {
        int oldWidth = configuration.screenWidthDp;
        configuration.screenWidthDp = configuration.screenHeightDp;
        configuration.screenHeightDp = oldWidth;
    }

    private static void setLocale(int apiLevel, Configuration configuration, Locale locale) {
        if (apiLevel >= 17) {
            configuration.setLocale(locale);
        } else {
            configuration.locale = locale;
        }
    }

    private static Locale getLocale(Configuration configuration, int apiLevel) {
        Locale locale = apiLevel > 23 ? configuration.getLocales().get(0) : configuration.locale;
        return locale;
    }

    private static int getScreenLayoutSize(Configuration configuration) {
        return configuration.screenLayout & 0xF;
    }

    private static void setScreenLayoutSize(Configuration configuration, int value) {
        configuration.screenLayout = configuration.screenLayout & 0xFFFFFFF0 | value;
    }

    private static int getScreenLayoutLong(Configuration configuration) {
        return configuration.screenLayout & 0x30;
    }

    private static void setScreenLayoutLong(Configuration configuration, int value) {
        configuration.screenLayout = configuration.screenLayout & 0xFFFFFFCF | value;
    }

    private static int getScreenLayoutLayoutDir(Configuration configuration) {
        return configuration.screenLayout & 0xC0;
    }

    private static void setScreenLayoutLayoutDir(Configuration configuration, int value) {
        configuration.screenLayout = configuration.screenLayout & 0xFFFFFF3F | value;
    }

    private static int getScreenLayoutRound(Configuration configuration) {
        return configuration.screenLayout & 0x300;
    }

    private static void setScreenLayoutRound(Configuration configuration, int value) {
        configuration.screenLayout = configuration.screenLayout & 0xFFFFFCFF | value;
    }

    private static int getUiModeType(Configuration configuration) {
        return configuration.uiMode & 0xF;
    }

    private static void setUiModeType(Configuration configuration, int value) {
        configuration.uiMode = configuration.uiMode & 0xFFFFFFF0 | value;
    }

    private static int getUiModeNight(Configuration configuration) {
        return configuration.uiMode & 0x30;
    }

    private static void setUiModeNight(Configuration configuration, int value) {
        configuration.uiMode = configuration.uiMode & 0xFFFFFFCF | value;
    }

    private static int getColorModeGamut(Configuration configuration) {
        return configuration.colorMode & 3;
    }

    private static void setColorModeGamut(Configuration configuration, int value) {
        configuration.colorMode = configuration.colorMode & 0xFFFFFFFC | value;
    }

    private static int getColorModeHdr(Configuration configuration) {
        return configuration.colorMode & 0xC;
    }

    private static void setColorModeHdr(Configuration configuration, int value) {
        configuration.colorMode = configuration.colorMode & 0xFFFFFFF3 | value;
    }

    public static enum ScreenSize {
        small(320, 426, 1),
        normal(320, 470, 2),
        large(480, 640, 3),
        xlarge(720, 960, 4);

        public final int width;
        public final int height;
        public final int landscapeWidth;
        public final int landscapeHeight;
        private final int configValue;

        private ScreenSize(int width, int height, int configValue) {
            this.width = width;
            this.height = height;
            this.landscapeWidth = height;
            this.landscapeHeight = width;
            this.configValue = configValue;
        }

        private boolean isSmallerThanOrEqualTo(int x, int y) {
            if (y < x) {
                int oldY = y;
                y = x;
                x = oldY;
            }
            return this.width <= x && this.height <= y;
        }

        static ScreenSize find(int configValue) {
            switch (configValue) {
                case 1: {
                    return small;
                }
                case 2: {
                    return normal;
                }
                case 3: {
                    return large;
                }
                case 4: {
                    return xlarge;
                }
                case 0: {
                    return null;
                }
            }
            throw new IllegalArgumentException();
        }

        static ScreenSize match(int x, int y) {
            ScreenSize bestMatch = small;
            for (ScreenSize screenSize : ScreenSize.values()) {
                if (!screenSize.isSmallerThanOrEqualTo(x, y)) continue;
                bestMatch = screenSize;
            }
            return bestMatch;
        }
    }
}

