/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robolectric.shadows;

import static android.os.Build.VERSION_CODES.LOLLIPOP_MR1;

import android.util.FloatMath;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

/** Shadow for {@link FloatMath}. Prior to SDK 23, this was implemented using native methods. */
@SuppressWarnings({"UnusedDeclaration"})
@Implements(value = FloatMath.class, maxSdk = LOLLIPOP_MR1)
public class ShadowFloatMath {
  @Implementation
  protected static float floor(float value) {
    return (float) Math.floor(value);
  }

  @Implementation
  protected static float ceil(float value) {
    return (float) Math.ceil(value);
  }

  @Implementation
  protected static float sin(float angle) {
    return (float) Math.sin(angle);
  }

  @Implementation
  protected static float cos(float angle) {
    return (float) Math.cos(angle);
  }

  @Implementation
  protected static float sqrt(float value) {
    return (float) Math.sqrt(value);
  }
}
