/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(className="android.app.SystemServiceRegistry", isInAndroidSdk=false, looseSignatures=true, minSdk=23)
public class ShadowSystemServiceRegistry {
    private static final String STATIC_SERVICE_FETCHER_CLASS_NAME = "android.app.SystemServiceRegistry$StaticServiceFetcher";
    private static final String STATIC_CONTEXT_SERVICE_FETCHER_CLASS_NAME_M = "android.app.SystemServiceRegistry$StaticOuterContextServiceFetcher";
    private static final String STATIC_CONTEXT_SERVICE_FETCHER_CLASS_NAME_N = "android.app.SystemServiceRegistry$StaticApplicationContextServiceFetcher";
    private static final String CACHED_SERVICE_FETCHER_CLASS_NAME = "android.app.SystemServiceRegistry$CachedServiceFetcher";

    @Resetter
    public static void reset() {
        Map<String, Object> fetchers = ((_SystemServiceRegistry_)Reflector.reflector(_SystemServiceRegistry_.class)).getSystemServiceFetchers();
        for (Map.Entry<String, Object> oFetcher : fetchers.entrySet()) {
            _ServiceFetcher_.get(oFetcher.getKey(), oFetcher.getValue()).clearInstance();
        }
    }

    @Implementation(minSdk=26)
    protected static void onServiceNotFound(Object e0) {
        Exception e = (Exception)e0;
        e.printStackTrace();
    }

    private static Class classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @ForType(className="android.app.SystemServiceRegistry$StaticApplicationContextServiceFetcher")
    public static interface _ServiceFetcherN_
    extends _ServiceFetcher_ {
        @Override
        @Accessor(value="mCachedInstance")
        public void setCachedInstance(Object var1);
    }

    @ForType(className="android.app.SystemServiceRegistry$StaticOuterContextServiceFetcher")
    public static interface _ServiceFetcherM_
    extends _ServiceFetcher_ {
        @Override
        @Accessor(value="mCachedInstance")
        public void setCachedInstance(Object var1);
    }

    @ForType(className="android.app.SystemServiceRegistry$StaticServiceFetcher")
    public static interface _StaticServiceFetcher_
    extends _ServiceFetcher_ {
        @Override
        @Accessor(value="mCachedInstance")
        public void setCachedInstance(Object var1);
    }

    static interface _ServiceFetcher_ {
        public void setCachedInstance(Object var1);

        public static _ServiceFetcher_ get(String key, Object serviceFetcher) {
            String serviceFetcherClassName = _ServiceFetcher_.getConcreteClassName(serviceFetcher);
            if (serviceFetcherClassName == null) {
                throw new IllegalStateException("could not find class name for serviceFetcher " + key);
            }
            switch (serviceFetcherClassName) {
                case "android.app.SystemServiceRegistry$StaticServiceFetcher": {
                    return (_ServiceFetcher_)Reflector.reflector(_StaticServiceFetcher_.class, (Object)serviceFetcher);
                }
                case "android.app.SystemServiceRegistry$StaticOuterContextServiceFetcher": {
                    return (_ServiceFetcher_)Reflector.reflector(_ServiceFetcherM_.class, (Object)serviceFetcher);
                }
                case "android.app.SystemServiceRegistry$StaticApplicationContextServiceFetcher": {
                    return (_ServiceFetcher_)Reflector.reflector(_ServiceFetcherN_.class, (Object)serviceFetcher);
                }
                case "android.app.SystemServiceRegistry$CachedServiceFetcher": {
                    return o -> {};
                }
            }
            if (key.equals("input_method")) {
                return o -> {};
            }
            if (key.equals("input")) {
                return o -> {};
            }
            throw new IllegalStateException("did not recognize serviceFetcher class name " + serviceFetcherClassName + " for key '" + key + "'");
        }

        public static String getConcreteClassName(Object serviceFetcher) {
            Class<?> serviceFetcherClass;
            for (serviceFetcherClass = serviceFetcher.getClass(); serviceFetcherClass != null && serviceFetcherClass.getCanonicalName() == null; serviceFetcherClass = serviceFetcherClass.getSuperclass()) {
            }
            return serviceFetcherClass == null ? null : serviceFetcherClass.getName();
        }

        default public void clearInstance() {
            this.setCachedInstance(null);
        }
    }

    @ForType(className="android.app.SystemServiceRegistry")
    static interface _SystemServiceRegistry_ {
        @Accessor(value="SYSTEM_SERVICE_FETCHERS")
        public Map<String, Object> getSystemServiceFetchers();
    }
}

