/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.NinePatch;
import android.graphics.Rect;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.NinePatchNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowNinePatch;

@Implements(value=NinePatch.class, minSdk=26, shadowPicker=Picker.class, isInAndroidSdk=false)
public class ShadowNativeNinePatch {
    @Implementation
    protected static boolean isNinePatchChunk(byte[] chunk) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return NinePatchNatives.isNinePatchChunk((byte[])chunk);
    }

    @Implementation
    protected static long validateNinePatchChunk(byte[] chunk) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return NinePatchNatives.validateNinePatchChunk((byte[])chunk);
    }

    @Implementation
    protected static void nativeFinalize(long chunk) {
        NinePatchNatives.nativeFinalize((long)chunk);
    }

    @Implementation(minSdk=29)
    protected static long nativeGetTransparentRegion(long bitmapHandle, long chunk, Rect location) {
        return NinePatchNatives.nativeGetTransparentRegion((long)bitmapHandle, (long)chunk, (Rect)location);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowNinePatch.class, ShadowNativeNinePatch.class);
        }
    }
}

