/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowBitmapFactory;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=MediaStore.class)
public class ShadowMediaStore {
    private static Bitmap stubBitmap = null;

    @Resetter
    public static void reset() {
        stubBitmap = null;
    }

    public static void setStubBitmapForThumbnails(Bitmap bitmap) {
        stubBitmap = bitmap;
    }

    @ForType(value=MediaStore.Video.Thumbnails.class)
    static interface VideoThumbnailsReflector {
        @Direct
        public Bitmap getThumbnail(ContentResolver var1, long var2, int var4, BitmapFactory.Options var5);
    }

    @ForType(value=MediaStore.Images.Thumbnails.class)
    static interface ImagesThumbnailsReflector {
        @Direct
        public Bitmap getThumbnail(ContentResolver var1, long var2, int var4, BitmapFactory.Options var5);
    }

    @Implements(value=MediaStore.Video.class)
    public static class ShadowVideo {

        @Implements(value=MediaStore.Video.Thumbnails.class)
        public static class ShadowThumbnails {
            @Implementation
            protected static Bitmap getThumbnail(ContentResolver cr, long imageId, int kind, BitmapFactory.Options options) {
                if (stubBitmap != null) {
                    return stubBitmap;
                }
                return ((VideoThumbnailsReflector)Reflector.reflector(VideoThumbnailsReflector.class)).getThumbnail(cr, imageId, kind, options);
            }
        }
    }

    @Implements(value=MediaStore.Images.class)
    public static class ShadowImages {

        @Implements(value=MediaStore.Images.Thumbnails.class)
        public static class ShadowThumbnails {
            @Implementation
            protected static Bitmap getThumbnail(ContentResolver cr, long imageId, int kind, BitmapFactory.Options options) {
                if (stubBitmap != null) {
                    return stubBitmap;
                }
                return ((ImagesThumbnailsReflector)Reflector.reflector(ImagesThumbnailsReflector.class)).getThumbnail(cr, imageId, kind, options);
            }
        }

        @Implements(value=MediaStore.Images.Media.class)
        public static class ShadowMedia {
            @Implementation
            protected static Bitmap getBitmap(ContentResolver cr, Uri url) {
                if (ShadowView.useRealGraphics()) {
                    return Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                return ShadowBitmapFactory.create(url.toString(), null, null);
            }
        }
    }
}

