/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Point;
import android.graphics.Rect;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ImageUtil;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=BitmapRegionDecoder.class)
public class ShadowBitmapRegionDecoder {
    private int width;
    private int height;

    @Implementation
    protected static BitmapRegionDecoder newInstance(byte[] data, int offset, int length, boolean isShareable) throws IOException {
        return ShadowBitmapRegionDecoder.fillWidthAndHeight(ShadowBitmapRegionDecoder.newInstance(), new ByteArrayInputStream(data));
    }

    @Implementation
    protected static BitmapRegionDecoder newInstance(FileDescriptor fd, boolean isShareable) throws IOException {
        return ShadowBitmapRegionDecoder.fillWidthAndHeight(ShadowBitmapRegionDecoder.newInstance(), new FileInputStream(fd));
    }

    @Implementation
    protected static BitmapRegionDecoder newInstance(InputStream is, boolean isShareable) throws IOException {
        return ShadowBitmapRegionDecoder.fillWidthAndHeight(ShadowBitmapRegionDecoder.newInstance(), is);
    }

    @Implementation
    protected static BitmapRegionDecoder newInstance(String pathName, boolean isShareable) throws IOException {
        return ShadowBitmapRegionDecoder.fillWidthAndHeight(ShadowBitmapRegionDecoder.newInstance(), new FileInputStream(pathName));
    }

    private static BitmapRegionDecoder fillWidthAndHeight(BitmapRegionDecoder bitmapRegionDecoder, InputStream is) {
        ShadowBitmapRegionDecoder shadowDecoder = (ShadowBitmapRegionDecoder)Shadow.extract((Object)bitmapRegionDecoder);
        Point imageSize = ImageUtil.getImageSizeFromStream(is);
        if (imageSize != null) {
            shadowDecoder.width = imageSize.x;
            shadowDecoder.height = imageSize.y;
        }
        return bitmapRegionDecoder;
    }

    @Implementation
    protected int getWidth() {
        return this.width;
    }

    @Implementation
    protected int getHeight() {
        return this.height;
    }

    @Implementation
    protected Bitmap decodeRegion(Rect rect, BitmapFactory.Options options) {
        return Bitmap.createBitmap((int)rect.width(), (int)rect.height(), (Bitmap.Config)(options.inPreferredConfig != null ? options.inPreferredConfig : Bitmap.Config.ARGB_8888));
    }

    private static BitmapRegionDecoder newInstance() {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return (BitmapRegionDecoder)ReflectionHelpers.callConstructor(BitmapRegionDecoder.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{new ReflectionHelpers.ClassParameter(Long.TYPE, (Object)0L)});
        }
        return (BitmapRegionDecoder)ReflectionHelpers.callConstructor(BitmapRegionDecoder.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{new ReflectionHelpers.ClassParameter(Integer.TYPE, (Object)0)});
    }
}

