/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioRecord;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;

@Implements(value=AudioRecord.class, minSdk=21)
public final class ShadowAudioRecord {
    @RealObject
    AudioRecord audioRecord;
    private static final AudioRecordSource DEFAULT_SOURCE = new AudioRecordSource(){};
    private static final AtomicReference<AudioRecordSourceProvider> audioRecordSourceProvider = new AtomicReference<AudioRecordSourceProvider>(audioRecord -> DEFAULT_SOURCE);

    @Deprecated
    public static void setSource(AudioRecordSource source) {
        audioRecordSourceProvider.set(audioRecord -> source);
    }

    public static void setSourceProvider(AudioRecordSourceProvider audioRecordSourceProvider) {
        ShadowAudioRecord.audioRecordSourceProvider.set(audioRecordSourceProvider);
    }

    @Resetter
    public static void clearSource() {
        ShadowAudioRecord.setSource(DEFAULT_SOURCE);
    }

    @Implementation
    protected static int native_get_min_buff_size(int sampleRateInHz, int channelCount, int audioFormat) {
        int frameSize;
        switch (audioFormat) {
            case 2: {
                frameSize = 2;
                break;
            }
            case 4: {
                frameSize = 2 * channelCount;
                break;
            }
            default: {
                return -2;
            }
        }
        return frameSize * (sampleRateInHz / 4);
    }

    @Implementation
    protected int native_start(int syncEvent, int sessionId) {
        return 0;
    }

    @Implementation(maxSdk=22)
    protected int native_read_in_byte_array(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        return this.native_read_in_byte_array(audioData, offsetInBytes, sizeInBytes, true);
    }

    @Implementation(minSdk=23)
    protected int native_read_in_byte_array(byte[] audioData, int offsetInBytes, int sizeInBytes, boolean isBlocking) {
        return this.getAudioRecordSource().readInByteArray(audioData, offsetInBytes, sizeInBytes, isBlocking);
    }

    @Implementation(maxSdk=22)
    protected int native_read_in_short_array(short[] audioData, int offsetInShorts, int sizeInShorts) {
        return this.native_read_in_short_array(audioData, offsetInShorts, sizeInShorts, true);
    }

    @Implementation(minSdk=23)
    protected int native_read_in_short_array(short[] audioData, int offsetInShorts, int sizeInShorts, boolean isBlocking) {
        return this.getAudioRecordSource().readInShortArray(audioData, offsetInShorts, sizeInShorts, isBlocking);
    }

    @Implementation(minSdk=23)
    protected int native_read_in_float_array(float[] audioData, int offsetInFloats, int sizeInFloats, boolean isBlocking) {
        return this.getAudioRecordSource().readInFloatArray(audioData, offsetInFloats, sizeInFloats, isBlocking);
    }

    @Implementation(maxSdk=22)
    protected int native_read_in_direct_buffer(Object jBuffer, int sizeInBytes) {
        return this.native_read_in_direct_buffer(jBuffer, sizeInBytes, true);
    }

    @Implementation(minSdk=23)
    protected int native_read_in_direct_buffer(Object jBuffer, int sizeInBytes, boolean isBlocking) {
        return this.getAudioRecordSource().readInDirectBuffer(((ByteBuffer)jBuffer).duplicate(), sizeInBytes, isBlocking);
    }

    private AudioRecordSource getAudioRecordSource() {
        return audioRecordSourceProvider.get().get(this.audioRecord);
    }

    public static interface AudioRecordSource {
        default public int readInByteArray(byte[] audioData, int offsetInBytes, int sizeInBytes, boolean isBlocking) {
            return sizeInBytes;
        }

        default public int readInShortArray(short[] audioData, int offsetInShorts, int sizeInShorts, boolean isBlocking) {
            return sizeInShorts;
        }

        default public int readInFloatArray(float[] audioData, int offsetInFloats, int sizeInFloats, boolean isBlocking) {
            return sizeInFloats;
        }

        default public int readInDirectBuffer(ByteBuffer buffer, int sizeInBytes, boolean isBlocking) {
            int maxBytes = Math.min(buffer.remaining(), sizeInBytes);
            ((Buffer)buffer).position(buffer.position() + maxBytes);
            return maxBytes;
        }
    }

    public static interface AudioRecordSourceProvider {
        public AudioRecordSource get(AudioRecord var1);
    }
}

