/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import androidx.annotation.Nullable;
import org.robolectric.shadows.GnssStatusBuilder;

final class AutoValue_GnssStatusBuilder_GnssSatelliteInfo
extends GnssStatusBuilder.GnssSatelliteInfo {
    private final int constellation;
    private final int svid;
    private final float cn0DbHz;
    private final float elevation;
    private final float azimuth;
    private final boolean hasEphemeris;
    private final boolean hasAlmanac;
    private final boolean usedInFix;
    private final Float carrierFrequencyHz;

    private AutoValue_GnssStatusBuilder_GnssSatelliteInfo(int constellation, int svid, float cn0DbHz, float elevation, float azimuth, boolean hasEphemeris, boolean hasAlmanac, boolean usedInFix, @Nullable Float carrierFrequencyHz) {
        this.constellation = constellation;
        this.svid = svid;
        this.cn0DbHz = cn0DbHz;
        this.elevation = elevation;
        this.azimuth = azimuth;
        this.hasEphemeris = hasEphemeris;
        this.hasAlmanac = hasAlmanac;
        this.usedInFix = usedInFix;
        this.carrierFrequencyHz = carrierFrequencyHz;
    }

    @Override
    public int getConstellation() {
        return this.constellation;
    }

    @Override
    public int getSvid() {
        return this.svid;
    }

    @Override
    public float getCn0DbHz() {
        return this.cn0DbHz;
    }

    @Override
    public float getElevation() {
        return this.elevation;
    }

    @Override
    public float getAzimuth() {
        return this.azimuth;
    }

    @Override
    public boolean getHasEphemeris() {
        return this.hasEphemeris;
    }

    @Override
    public boolean getHasAlmanac() {
        return this.hasAlmanac;
    }

    @Override
    public boolean isUsedInFix() {
        return this.usedInFix;
    }

    @Override
    @Nullable
    public Float getCarrierFrequencyHz() {
        return this.carrierFrequencyHz;
    }

    public String toString() {
        return "GnssSatelliteInfo{constellation=" + this.constellation + ", svid=" + this.svid + ", cn0DbHz=" + this.cn0DbHz + ", elevation=" + this.elevation + ", azimuth=" + this.azimuth + ", hasEphemeris=" + this.hasEphemeris + ", hasAlmanac=" + this.hasAlmanac + ", usedInFix=" + this.usedInFix + ", carrierFrequencyHz=" + this.carrierFrequencyHz + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GnssStatusBuilder.GnssSatelliteInfo) {
            GnssStatusBuilder.GnssSatelliteInfo that = (GnssStatusBuilder.GnssSatelliteInfo)o;
            return this.constellation == that.getConstellation() && this.svid == that.getSvid() && Float.floatToIntBits(this.cn0DbHz) == Float.floatToIntBits(that.getCn0DbHz()) && Float.floatToIntBits(this.elevation) == Float.floatToIntBits(that.getElevation()) && Float.floatToIntBits(this.azimuth) == Float.floatToIntBits(that.getAzimuth()) && this.hasEphemeris == that.getHasEphemeris() && this.hasAlmanac == that.getHasAlmanac() && this.usedInFix == that.isUsedInFix() && (this.carrierFrequencyHz == null ? that.getCarrierFrequencyHz() == null : this.carrierFrequencyHz.equals(that.getCarrierFrequencyHz()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.constellation;
        h$ *= 1000003;
        h$ ^= this.svid;
        h$ *= 1000003;
        h$ ^= Float.floatToIntBits(this.cn0DbHz);
        h$ *= 1000003;
        h$ ^= Float.floatToIntBits(this.elevation);
        h$ *= 1000003;
        h$ ^= Float.floatToIntBits(this.azimuth);
        h$ *= 1000003;
        h$ ^= this.hasEphemeris ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.hasAlmanac ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.usedInFix ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.carrierFrequencyHz == null ? 0 : this.carrierFrequencyHz.hashCode();
    }

    static final class Builder
    extends GnssStatusBuilder.GnssSatelliteInfo.Builder {
        private int constellation;
        private int svid;
        private float cn0DbHz;
        private float elevation;
        private float azimuth;
        private boolean hasEphemeris;
        private boolean hasAlmanac;
        private boolean usedInFix;
        private Float carrierFrequencyHz;
        private byte set$0;

        Builder() {
        }

        @Override
        public GnssStatusBuilder.GnssSatelliteInfo.Builder setConstellation(int constellation) {
            this.constellation = constellation;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public GnssStatusBuilder.GnssSatelliteInfo.Builder setSvid(int svid) {
            this.svid = svid;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public GnssStatusBuilder.GnssSatelliteInfo.Builder setCn0DbHz(float cn0DbHz) {
            this.cn0DbHz = cn0DbHz;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public GnssStatusBuilder.GnssSatelliteInfo.Builder setElevation(float elevation) {
            this.elevation = elevation;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public GnssStatusBuilder.GnssSatelliteInfo.Builder setAzimuth(float azimuth) {
            this.azimuth = azimuth;
            this.set$0 = (byte)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public GnssStatusBuilder.GnssSatelliteInfo.Builder setHasEphemeris(boolean hasEphemeris) {
            this.hasEphemeris = hasEphemeris;
            this.set$0 = (byte)(this.set$0 | 0x20);
            return this;
        }

        @Override
        public GnssStatusBuilder.GnssSatelliteInfo.Builder setHasAlmanac(boolean hasAlmanac) {
            this.hasAlmanac = hasAlmanac;
            this.set$0 = (byte)(this.set$0 | 0x40);
            return this;
        }

        @Override
        public GnssStatusBuilder.GnssSatelliteInfo.Builder setUsedInFix(boolean usedInFix) {
            this.usedInFix = usedInFix;
            this.set$0 = (byte)(this.set$0 | 0x80);
            return this;
        }

        @Override
        public GnssStatusBuilder.GnssSatelliteInfo.Builder setCarrierFrequencyHz(@Nullable Float carrierFrequencyHz) {
            this.carrierFrequencyHz = carrierFrequencyHz;
            return this;
        }

        @Override
        public GnssStatusBuilder.GnssSatelliteInfo build() {
            if (this.set$0 != -1) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" constellation");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" svid");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" cn0DbHz");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" elevation");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" azimuth");
                }
                if ((this.set$0 & 0x20) == 0) {
                    missing.append(" hasEphemeris");
                }
                if ((this.set$0 & 0x40) == 0) {
                    missing.append(" hasAlmanac");
                }
                if ((this.set$0 & 0x80) == 0) {
                    missing.append(" usedInFix");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GnssStatusBuilder_GnssSatelliteInfo(this.constellation, this.svid, this.cn0DbHz, this.elevation, this.azimuth, this.hasEphemeris, this.hasAlmanac, this.usedInFix, this.carrierFrequencyHz);
        }
    }
}

