/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.StateSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowDrawable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Implements(value=StateListDrawable.class)
public class ShadowStateListDrawable
extends ShadowDrawable {
    private final Map<Integer, Integer> stateToResource = new HashMap<Integer, Integer>();
    private final Map<List<Integer>, Drawable> stateToDrawable = new HashMap<List<Integer>, Drawable>();

    public void addState(int stateId, int resId) {
        this.stateToResource.put(stateId, resId);
    }

    public int getResourceIdForState(int stateId) {
        return this.stateToResource.get(stateId);
    }

    @Implementation
    public void addState(int[] stateSet, Drawable drawable) {
        this.stateToDrawable.put(this.createStateList(stateSet), drawable);
    }

    @Implementation
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
    }

    public Drawable getDrawableForState(int[] stateSet) {
        return this.stateToDrawable.get(this.createStateList(stateSet));
    }

    private List<Integer> createStateList(int[] stateSet) {
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        if (stateSet == StateSet.WILD_CARD) {
            stateList.add(-1);
        } else {
            for (int state : stateSet) {
                stateList.add(state);
            }
        }
        return stateList;
    }
}

