/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.util.AttributeSet;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.res.Attribute;
import org.robolectric.res.PreferenceNode;
import org.robolectric.res.ResName;
import org.robolectric.shadows.RoboAttributeSet;

public class PreferenceBuilder {
    private Class<? extends Preference> loadClass(String className) {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Preference inflate(PreferenceNode preferenceNode, Activity activity, Preference parent) {
        if ("intent".equals(preferenceNode.getName())) {
            parent.setIntent(this.createIntent(preferenceNode));
            return null;
        }
        Preference preference = this.create(preferenceNode, (Context)activity, (PreferenceGroup)parent);
        Shadows.shadowOf(preference).callOnAttachedToHierarchy(((PreferenceActivity)activity).getPreferenceManager());
        for (PreferenceNode child : preferenceNode.getChildren()) {
            this.inflate(child, activity, preference);
        }
        return preference;
    }

    private Preference create(PreferenceNode preferenceNode, Context context, PreferenceGroup parent) {
        Preference preference = this.constructPreference(preferenceNode, context);
        if (parent != null && parent != preference) {
            parent.addPreference(preference);
        }
        return preference;
    }

    private Preference constructPreference(PreferenceNode preferenceNode, Context context) {
        Class<? extends Preference> clazz = this.pickViewClass(preferenceNode);
        List attributes = preferenceNode.getAttributes();
        RoboAttributeSet attributeSet = Shadows.shadowOf(context).createAttributeSet(attributes, null);
        try {
            return clazz.getConstructor(Context.class, AttributeSet.class).newInstance(context, attributeSet);
        }
        catch (NoSuchMethodException e) {
            try {
                try {
                    return clazz.getConstructor(Context.class).newInstance(context);
                }
                catch (NoSuchMethodException e1) {
                    return clazz.getConstructor(Context.class, String.class).newInstance(context, "");
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private Class<? extends Preference> pickViewClass(PreferenceNode preferenceNode) {
        String name = preferenceNode.getName();
        Class<? extends Preference> clazz = this.loadClass(name);
        if (clazz == null) {
            clazz = this.loadClass("android.preference." + name);
        }
        if (clazz == null) {
            throw new RuntimeException("couldn't find preference class " + name);
        }
        return clazz;
    }

    private Intent createIntent(PreferenceNode preferenceNode) {
        String targetPackage = PreferenceBuilder.getAttribute(preferenceNode, "targetPackage");
        String targetClass = PreferenceBuilder.getAttribute(preferenceNode, "targetClass");
        String mimeType = PreferenceBuilder.getAttribute(preferenceNode, "mimeType");
        String data = PreferenceBuilder.getAttribute(preferenceNode, "data");
        String action = PreferenceBuilder.getAttribute(preferenceNode, "action");
        Intent intent = new Intent();
        if (targetClass != null && targetPackage != null) {
            intent.setComponent(new ComponentName(targetPackage, targetClass));
        }
        if (mimeType != null) {
            intent.setDataAndType(data != null ? Uri.parse((String)data) : null, mimeType);
        }
        intent.setAction(action);
        return intent;
    }

    private static String getAttribute(PreferenceNode node, String name) {
        Attribute attr = Attribute.find((List)node.getAttributes(), (ResName)new ResName("android", "attr", name));
        return attr != null ? attr.value : null;
    }
}

