/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.fakes.RoboWebSettings;
import org.robolectric.shadows.ShadowAbsoluteLayout;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=WebView.class, inheritImplementationMethods=true)
public class ShadowWebView
extends ShadowAbsoluteLayout {
    @RealObject
    private WebView realWebView;
    private String lastUrl;
    private Map<String, String> lastAdditionalHttpHeaders;
    private HashMap<String, Object> javascriptInterfaces = new HashMap();
    private WebSettings webSettings = new RoboWebSettings();
    private WebViewClient webViewClient = null;
    private boolean runFlag = false;
    private boolean clearCacheCalled = false;
    private boolean clearCacheIncludeDiskFiles = false;
    private boolean clearFormDataCalled = false;
    private boolean clearHistoryCalled = false;
    private boolean clearViewCalled = false;
    private boolean destroyCalled = false;
    private boolean onPauseCalled = false;
    private boolean onResumeCalled = false;
    private WebChromeClient webChromeClient;
    private boolean canGoBack;
    private int goBackInvocations = 0;
    private LoadData lastLoadData;
    private LoadDataWithBaseURL lastLoadDataWithBaseURL;
    private WebView.PictureListener pictureListener;

    @HiddenApi
    @Implementation
    public void ensureProviderCreated() {
        final ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> webViewProviderClass = this.getClassNamed("android.webkit.WebViewProvider");
        try {
            Field mProvider = WebView.class.getDeclaredField("mProvider");
            mProvider.setAccessible(true);
            if (mProvider.get(this.realView) == null) {
                Object provider = Proxy.newProxyInstance(classLoader, new Class[]{webViewProviderClass}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("getViewDelegate") || method.getName().equals("getScrollDelegate")) {
                            return Proxy.newProxyInstance(classLoader, new Class[]{ShadowWebView.this.getClassNamed("android.webkit.WebViewProvider$ViewDelegate"), ShadowWebView.this.getClassNamed("android.webkit.WebViewProvider$ScrollDelegate")}, new InvocationHandler(){

                                @Override
                                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                    return ShadowWebView.this.nullish(method);
                                }
                            });
                        }
                        return ShadowWebView.this.nullish(method);
                    }
                });
                mProvider.set(this.realView, provider);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public void setLayoutParams(ViewGroup.LayoutParams params) {
        ReflectionHelpers.setField((Object)this.realWebView, (String)"mLayoutParams", (Object)params);
    }

    private Object nullish(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Long.TYPE) || returnType.equals(Double.TYPE) || returnType.equals(Integer.TYPE) || returnType.equals(Float.TYPE) || returnType.equals(Short.TYPE) || returnType.equals(Byte.TYPE)) {
            return 0;
        }
        if (returnType.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (returnType.equals(Boolean.TYPE)) {
            return false;
        }
        return null;
    }

    private Class<?> getClassNamed(String className) {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public void loadUrl(String url) {
        this.loadUrl(url, null);
    }

    @Implementation
    public void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        this.lastUrl = url;
        this.lastAdditionalHttpHeaders = additionalHttpHeaders != null ? Collections.unmodifiableMap(additionalHttpHeaders) : null;
    }

    @Implementation
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        this.lastLoadDataWithBaseURL = new LoadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }

    @Implementation
    public void loadData(String data, String mimeType, String encoding) {
        this.lastLoadData = new LoadData(data, mimeType, encoding);
    }

    public String getLastLoadedUrl() {
        return this.lastUrl;
    }

    public Map<String, String> getLastAdditionalHttpHeaders() {
        return this.lastAdditionalHttpHeaders;
    }

    @Implementation
    public WebSettings getSettings() {
        return this.webSettings;
    }

    @Implementation
    public void setWebViewClient(WebViewClient client) {
        this.webViewClient = client;
    }

    @Implementation
    public void setWebChromeClient(WebChromeClient client) {
        this.webChromeClient = client;
    }

    public WebViewClient getWebViewClient() {
        return this.webViewClient;
    }

    @Implementation
    public void setPictureListener(WebView.PictureListener listener) {
        this.pictureListener = listener;
    }

    public WebView.PictureListener getPictureListener() {
        return this.pictureListener;
    }

    @Implementation
    public void addJavascriptInterface(Object obj, String interfaceName) {
        this.javascriptInterfaces.put(interfaceName, obj);
    }

    public Object getJavascriptInterface(String interfaceName) {
        return this.javascriptInterfaces.get(interfaceName);
    }

    @Implementation
    public void clearCache(boolean includeDiskFiles) {
        this.clearCacheCalled = true;
        this.clearCacheIncludeDiskFiles = includeDiskFiles;
    }

    public boolean wasClearCacheCalled() {
        return this.clearCacheCalled;
    }

    public boolean didClearCacheIncludeDiskFiles() {
        return this.clearCacheIncludeDiskFiles;
    }

    @Implementation
    public void clearFormData() {
        this.clearFormDataCalled = true;
    }

    public boolean wasClearFormDataCalled() {
        return this.clearFormDataCalled;
    }

    @Implementation
    public void clearHistory() {
        this.clearHistoryCalled = true;
    }

    public boolean wasClearHistoryCalled() {
        return this.clearHistoryCalled;
    }

    @Implementation
    public void clearView() {
        this.clearViewCalled = true;
    }

    public boolean wasClearViewCalled() {
        return this.clearViewCalled;
    }

    @Implementation
    public void onPause() {
        this.onPauseCalled = true;
    }

    public boolean wasOnPauseCalled() {
        return this.onPauseCalled;
    }

    @Implementation
    public void onResume() {
        this.onResumeCalled = true;
    }

    public boolean wasOnResumeCalled() {
        return this.onResumeCalled;
    }

    @Implementation
    public void destroy() {
        this.destroyCalled = true;
    }

    public boolean wasDestroyCalled() {
        return this.destroyCalled;
    }

    @Override
    @Implementation
    public void post(Runnable action) {
        action.run();
        this.runFlag = true;
    }

    public boolean getRunFlag() {
        return this.runFlag;
    }

    public WebChromeClient getWebChromeClient() {
        return this.webChromeClient;
    }

    @Implementation
    public boolean canGoBack() {
        return this.canGoBack;
    }

    @Implementation
    public void goBack() {
        ++this.goBackInvocations;
    }

    @Implementation
    public static String findAddress(String addr) {
        return null;
    }

    public int getGoBackInvocations() {
        return this.goBackInvocations;
    }

    public void setCanGoBack(boolean canGoBack) {
        this.canGoBack = canGoBack;
    }

    public LoadData getLastLoadData() {
        return this.lastLoadData;
    }

    public LoadDataWithBaseURL getLastLoadDataWithBaseURL() {
        return this.lastLoadDataWithBaseURL;
    }

    public static void setWebContentsDebuggingEnabled(boolean enabled) {
    }

    public class LoadData {
        public final String data;
        public final String mimeType;
        public final String encoding;

        public LoadData(String data, String mimeType, String encoding) {
            this.data = data;
            this.mimeType = mimeType;
            this.encoding = encoding;
        }
    }

    public class LoadDataWithBaseURL {
        public final String baseUrl;
        public final String data;
        public final String mimeType;
        public final String encoding;
        public final String historyUrl;

        public LoadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
            this.baseUrl = baseUrl;
            this.data = data;
            this.mimeType = mimeType;
            this.encoding = encoding;
            this.historyUrl = historyUrl;
        }
    }
}

