/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteCustomFunction;
import android.database.sqlite.SQLiteDoneException;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowCursorWindow;
import org.robolectric.shadows.util.SQLiteLibraryLoader;

@Implements(value=SQLiteConnection.class, isInAndroidSdk=false)
public class ShadowSQLiteConnection {
    private static final String IN_MEMORY_PATH = ":memory:";
    private static final Connections CONNECTIONS = new Connections();
    private static final Pattern COLLATE_LOCALIZED_UNICODE_PATTERN = Pattern.compile("\\s+COLLATE\\s+(LOCALIZED|UNICODE)", 2);
    private static final int IGNORED_REINDEX_STMT = -2;

    private static com.almworks.sqlite4java.SQLiteConnection connection(long pointer) {
        return CONNECTIONS.getConnection(pointer);
    }

    private static SQLiteStatement stmt(long connectionPtr, long pointer) {
        return CONNECTIONS.getStatement(connectionPtr, pointer);
    }

    private static void rethrow(String message, SQLiteException e) {
        throw new android.database.sqlite.SQLiteException(message + ", base error code: " + e.getBaseErrorCode(), (Throwable)e);
    }

    @Implementation
    public static long nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile) {
        return CONNECTIONS.open(path);
    }

    @Implementation
    public static long nativePrepareStatement(long connectionPtr, String sql) {
        String newSql = ShadowSQLiteConnection.convertSQLWithLocalizedUnicodeCollator(sql);
        return CONNECTIONS.prepareStatement(connectionPtr, newSql);
    }

    static String convertSQLWithLocalizedUnicodeCollator(String sql) {
        Matcher matcher = COLLATE_LOCALIZED_UNICODE_PATTERN.matcher(sql);
        return matcher.replaceAll(" COLLATE NOCASE");
    }

    @Resetter
    public static void reset() {
        CONNECTIONS.reset();
    }

    @Implementation
    public static void nativeClose(long connectionPtr) {
        CONNECTIONS.close(connectionPtr);
    }

    @Implementation
    public static void nativeFinalizeStatement(long connectionPtr, long statementPtr) {
        CONNECTIONS.finalizeStmt(connectionPtr, statementPtr);
    }

    @Implementation
    public static int nativeGetParameterCount(final long connectionPtr, final long statementPtr) {
        if (statementPtr == -2L) {
            return 0;
        }
        return CONNECTIONS.execute("get parameters count in prepared statement", new Callable<Integer>(){

            @Override
            public Integer call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                return stmt.getBindParameterCount();
            }
        });
    }

    @Implementation
    public static boolean nativeIsReadOnly(final long connectionPtr, final long statementPtr) {
        if (statementPtr == -2L) {
            return true;
        }
        return CONNECTIONS.execute("call isReadOnly", new Callable<Boolean>(){

            @Override
            public Boolean call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                return stmt.isReadOnly();
            }
        });
    }

    @Implementation
    public static long nativeExecuteForLong(final long connectionPtr, final long statementPtr) {
        return CONNECTIONS.execute("execute for long", new Callable<Long>(){

            @Override
            public Long call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                if (!stmt.step()) {
                    throw new SQLiteDoneException();
                }
                return stmt.columnLong(0);
            }
        });
    }

    @Implementation
    public static void nativeExecute(final long connectionPtr, final long statementPtr) {
        if (statementPtr == -2L) {
            return;
        }
        CONNECTIONS.execute("execute", new Callable<Object>(){

            @Override
            public Object call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.stepThrough();
                return null;
            }
        });
    }

    @Implementation
    public static String nativeExecuteForString(final long connectionPtr, final long statementPtr) {
        return CONNECTIONS.execute("execute for string", new Callable<String>(){

            @Override
            public String call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                if (!stmt.step()) {
                    throw new SQLiteDoneException();
                }
                return stmt.columnString(0);
            }
        });
    }

    @Implementation
    public static int nativeGetColumnCount(final long connectionPtr, final long statementPtr) {
        return CONNECTIONS.execute("get columns count", new Callable<Integer>(){

            @Override
            public Integer call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                return stmt.columnCount();
            }
        });
    }

    @Implementation
    public static String nativeGetColumnName(final long connectionPtr, final long statementPtr, final int index) {
        return CONNECTIONS.execute("get column name at index " + index, new Callable<String>(){

            @Override
            public String call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                return stmt.getColumnName(index);
            }
        });
    }

    @Implementation
    public static void nativeBindNull(final long connectionPtr, final long statementPtr, final int index) {
        CONNECTIONS.execute("bind null at index " + index, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.bindNull(index);
                return null;
            }
        });
    }

    @Implementation
    public static void nativeBindLong(final long connectionPtr, final long statementPtr, final int index, final long value) {
        CONNECTIONS.execute("bind long at index " + index + " with value " + value, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.bind(index, value);
                return null;
            }
        });
    }

    @Implementation
    public static void nativeBindDouble(final long connectionPtr, final long statementPtr, final int index, final double value) {
        CONNECTIONS.execute("bind double at index " + index + " with value " + value, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.bind(index, value);
                return null;
            }
        });
    }

    @Implementation
    public static void nativeBindString(final long connectionPtr, final long statementPtr, final int index, final String value) {
        CONNECTIONS.execute("bind string at index " + index, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.bind(index, value);
                return null;
            }
        });
    }

    @Implementation
    public static void nativeBindBlob(final long connectionPtr, final long statementPtr, final int index, final byte[] value) {
        CONNECTIONS.execute("bind blob at index " + index, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.bind(index, value);
                return null;
            }
        });
    }

    @Implementation
    public static void nativeRegisterLocalizedCollators(long connectionPtr, String locale) {
    }

    @Implementation
    public static int nativeExecuteForChangedRowCount(final long connectionPtr, final long statementPtr) {
        return CONNECTIONS.execute("execute for changed row count", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.stepThrough();
                return ShadowSQLiteConnection.connection(connectionPtr).getChanges();
            }
        });
    }

    @Implementation
    public static long nativeExecuteForLastInsertedRowId(final long connectionPtr, final long statementPtr) {
        return CONNECTIONS.execute("execute for last inserted row ID", new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.stepThrough();
                return ShadowSQLiteConnection.connection(connectionPtr).getLastInsertId();
            }
        });
    }

    @Implementation
    public static long nativeExecuteForCursorWindow(final long connectionPtr, final long statementPtr, final long windowPtr, int startPos, int requiredPos, boolean countAllRows) {
        return CONNECTIONS.execute("execute for cursor window", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                return ShadowCursorWindow.setData(windowPtr, stmt);
            }
        }).intValue();
    }

    @Implementation
    public static void nativeResetStatementAndClearBindings(final long connectionPtr, final long statementPtr) {
        CONNECTIONS.execute("reset statement", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.reset(true);
                return null;
            }
        });
    }

    @Implementation
    public static void nativeCancel(long connectionPtr) {
        CONNECTIONS.cancel(connectionPtr);
    }

    @Implementation
    public static void nativeResetCancel(long connectionPtr, boolean cancelable) {
    }

    @Implementation
    public static void nativeRegisterCustomFunction(long connectionPtr, SQLiteCustomFunction function) {
    }

    @Implementation
    public static int nativeExecuteForBlobFileDescriptor(long connectionPtr, long statementPtr) {
        return -1;
    }

    @Implementation
    public static int nativeGetDbLookaside(long connectionPtr) {
        return 0;
    }

    static {
        SQLiteLibraryLoader.load();
    }

    static class Connections {
        private final AtomicLong pointerCounter = new AtomicLong(0L);
        private final Map<Long, SQLiteStatement> statementsMap = new ConcurrentHashMap<Long, SQLiteStatement>();
        private final Map<Long, com.almworks.sqlite4java.SQLiteConnection> connectionsMap = new ConcurrentHashMap<Long, com.almworks.sqlite4java.SQLiteConnection>();
        private ExecutorService dbExecutor = Executors.newSingleThreadExecutor();

        Connections() {
        }

        public com.almworks.sqlite4java.SQLiteConnection getConnection(long pointer) {
            com.almworks.sqlite4java.SQLiteConnection connection = this.connectionsMap.get(pointer);
            if (connection == null) {
                throw new IllegalStateException("Illegal connection pointer " + pointer + ". Current pointers for thread " + Thread.currentThread() + " " + this.connectionsMap.keySet());
            }
            return connection;
        }

        public SQLiteStatement getStatement(long connectionPtr, long pointer) {
            this.getConnection(connectionPtr);
            SQLiteStatement stmt = this.statementsMap.get(pointer);
            if (stmt == null) {
                throw new IllegalArgumentException("Invalid prepared statement pointer: " + pointer + ". Current pointers: " + this.statementsMap.keySet());
            }
            if (stmt.isDisposed()) {
                throw new IllegalStateException("Statement " + pointer + " " + stmt + " is disposed");
            }
            return stmt;
        }

        public long open(final String path) {
            com.almworks.sqlite4java.SQLiteConnection dbConnection = this.execute("open SQLite connection", new Callable<com.almworks.sqlite4java.SQLiteConnection>(){

                @Override
                public com.almworks.sqlite4java.SQLiteConnection call() throws Exception {
                    com.almworks.sqlite4java.SQLiteConnection connection = ShadowSQLiteConnection.IN_MEMORY_PATH.equals(path) ? new com.almworks.sqlite4java.SQLiteConnection() : new com.almworks.sqlite4java.SQLiteConnection(new File(path));
                    connection.open();
                    return connection;
                }
            });
            long ptr = this.pointerCounter.incrementAndGet();
            this.connectionsMap.put(ptr, dbConnection);
            return ptr;
        }

        public long prepareStatement(final long connectionPtr, final String sql) {
            if ("REINDEX LOCALIZED".equals(sql)) {
                return -2L;
            }
            SQLiteStatement stmt = this.execute("prepare statement", new Callable<SQLiteStatement>(){

                @Override
                public SQLiteStatement call() throws Exception {
                    com.almworks.sqlite4java.SQLiteConnection connection = Connections.this.getConnection(connectionPtr);
                    return connection.prepare(sql);
                }
            });
            long pointer = this.pointerCounter.incrementAndGet();
            this.statementsMap.put(pointer, stmt);
            return pointer;
        }

        public void close(final long ptr) {
            this.execute("close connection", new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    com.almworks.sqlite4java.SQLiteConnection connection = Connections.this.getConnection(ptr);
                    connection.dispose();
                    return null;
                }
            });
        }

        public void reset() {
            for (long connectionPtr : this.connectionsMap.keySet()) {
                this.close(connectionPtr);
            }
            this.dbExecutor.shutdown();
            try {
                this.dbExecutor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.dbExecutor = Executors.newSingleThreadExecutor();
            this.connectionsMap.clear();
            this.statementsMap.clear();
        }

        public void finalizeStmt(final long connectionPtr, final long statementPtr) {
            if (statementPtr == -2L) {
                return;
            }
            this.execute("finalize statement", new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SQLiteStatement stmt = Connections.this.getStatement(connectionPtr, statementPtr);
                    Connections.this.statementsMap.remove(statementPtr);
                    stmt.dispose();
                    return null;
                }
            });
        }

        public void cancel(long connectionPtr) {
            this.getConnection(connectionPtr);
            this.execute("cancel", new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SQLiteStatement statement = (SQLiteStatement)Connections.this.statementsMap.get(Connections.this.pointerCounter.get());
                    if (statement != null) {
                        statement.cancel();
                    }
                    return null;
                }
            });
        }

        public <T> T execute(String comment, final Callable<T> work) {
            Future future = this.dbExecutor.submit(new Callable<DbOperationResult<T>>(){

                @Override
                public DbOperationResult<T> call() throws Exception {
                    Object result = null;
                    Exception error = null;
                    try {
                        result = work.call();
                    }
                    catch (Exception e) {
                        error = e;
                    }
                    return new DbOperationResult<Object>(result, error);
                }
            });
            try {
                DbOperationResult execResult = (DbOperationResult)future.get();
                if (execResult.error != null) {
                    if (execResult.error instanceof SQLiteException) {
                        ShadowSQLiteConnection.rethrow("Cannot " + comment, (SQLiteException)execResult.error);
                    } else {
                        if (execResult.error instanceof android.database.sqlite.SQLiteException) {
                            throw (android.database.sqlite.SQLiteException)execResult.error;
                        }
                        throw new RuntimeException(execResult.error);
                    }
                }
                return (T)execResult.value;
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private static class DbOperationResult<T> {
            private final T value;
            private final Exception error;

            DbOperationResult(T value, Exception error) {
                this.value = value;
                this.error = error;
            }
        }
    }
}

