/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.fakes.RoboIntentSender;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=PendingIntent.class)
public class ShadowPendingIntent {
    private static final List<PendingIntent> createdIntents = new ArrayList<PendingIntent>();
    private Intent[] savedIntents;
    private Context savedContext;
    private boolean isActivityIntent;
    private boolean isBroadcastIntent;
    private boolean isServiceIntent;
    private int requestCode;
    private int flags;

    @Implementation
    public static PendingIntent getActivity(Context context, int requestCode, Intent intent, int flags) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, true, false, false, requestCode, flags);
    }

    @Implementation
    public static PendingIntent getActivities(Context context, int requestCode, Intent[] intents, int flags) {
        return ShadowPendingIntent.create(context, intents, true, false, false, requestCode, flags);
    }

    @Implementation
    public static PendingIntent getActivities(Context context, int requestCode, Intent[] intents, int flags, Bundle options) {
        return ShadowPendingIntent.create(context, intents, true, false, false, requestCode, flags);
    }

    @Implementation
    public static PendingIntent getBroadcast(Context context, int requestCode, Intent intent, int flags) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, false, true, false, requestCode, flags);
    }

    @Implementation
    public static PendingIntent getService(Context context, int requestCode, Intent intent, int flags) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, false, false, true, requestCode, flags);
    }

    @Implementation
    public void send() throws PendingIntent.CanceledException {
        this.send(this.savedContext, 0, null);
    }

    @Implementation
    public void send(Context context, int code, Intent intent) throws PendingIntent.CanceledException {
        block6: {
            block7: {
                block5: {
                    if (intent != null) {
                        for (Intent savedIntent : this.savedIntents) {
                            savedIntent.fillIn(intent, 0);
                        }
                    }
                    if (!this.isActivityIntent) break block5;
                    for (Intent savedIntent : this.savedIntents) {
                        context.startActivity(savedIntent);
                    }
                    break block6;
                }
                if (!this.isBroadcastIntent) break block7;
                for (Intent savedIntent : this.savedIntents) {
                    context.sendBroadcast(savedIntent);
                }
                break block6;
            }
            if (!this.isServiceIntent) break block6;
            for (Intent savedIntent : this.savedIntents) {
                context.startService(savedIntent);
            }
        }
    }

    @Implementation
    public IntentSender getIntentSender() {
        RoboIntentSender testIntentSender = new RoboIntentSender();
        testIntentSender.intent = this.savedIntents[0];
        return testIntentSender;
    }

    public boolean isActivityIntent() {
        return this.isActivityIntent;
    }

    public boolean isBroadcastIntent() {
        return this.isBroadcastIntent;
    }

    public boolean isServiceIntent() {
        return this.isServiceIntent;
    }

    public Context getSavedContext() {
        return this.savedContext;
    }

    public Intent getSavedIntent() {
        return this.savedIntents[0];
    }

    public Intent[] getSavedIntents() {
        return this.savedIntents;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public int getFlags() {
        return this.flags;
    }

    @Implementation
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShadowPendingIntent that = (ShadowPendingIntent)o;
        if (this.savedContext != null) {
            String packageName = this.savedContext.getPackageName();
            String thatPackageName = that.savedContext.getPackageName();
            if (packageName != null ? !packageName.equals(thatPackageName) : thatPackageName != null) {
                return false;
            }
        } else if (that.savedContext != null) {
            return false;
        }
        return this.savedIntents == null || Arrays.equals(this.savedIntents, that.savedIntents);
    }

    @Implementation
    public int hashCode() {
        int result;
        int n = result = this.savedIntents != null ? Arrays.hashCode(this.savedIntents) : 0;
        if (this.savedContext != null) {
            String packageName = this.savedContext.getPackageName();
            result = 31 * result + (packageName != null ? packageName.hashCode() : 0);
        }
        return result;
    }

    private static PendingIntent create(Context context, Intent[] intents, boolean isActivity, boolean isBroadcast, boolean isService, int requestCode, int flags) {
        if ((flags & 0x20000000) != 0) {
            return ShadowPendingIntent.getCreatedIntentFor(intents);
        }
        PendingIntent pendingIntent = (PendingIntent)ReflectionHelpers.callConstructor(PendingIntent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowPendingIntent shadowPendingIntent = Shadows.shadowOf(pendingIntent);
        shadowPendingIntent.savedIntents = intents;
        shadowPendingIntent.isActivityIntent = isActivity;
        shadowPendingIntent.isBroadcastIntent = isBroadcast;
        shadowPendingIntent.isServiceIntent = isService;
        shadowPendingIntent.savedContext = context;
        shadowPendingIntent.requestCode = requestCode;
        shadowPendingIntent.flags = flags;
        createdIntents.add(pendingIntent);
        return pendingIntent;
    }

    private static PendingIntent getCreatedIntentFor(Intent[] intents) {
        for (PendingIntent createdIntent : createdIntents) {
            ShadowPendingIntent shadowPendingIntent = Shadows.shadowOf(createdIntent);
            if (shadowPendingIntent.savedIntents.length != intents.length) continue;
            boolean equalIntents = true;
            for (int i = 0; i < intents.length; ++i) {
                if (shadowPendingIntent.savedIntents[i].filterEquals(intents[i])) continue;
                equalIntents = false;
                break;
            }
            if (!equalIntents) continue;
            return createdIntent;
        }
        return null;
    }

    @Resetter
    public static void reset() {
        createdIntents.clear();
    }
}

