/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.IntentFilter;
import android.net.Uri;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=IntentFilter.class)
public class ShadowIntentFilter {
    List<String> actions = new ArrayList<String>();
    List<String> schemes = new ArrayList<String>();
    List<String> types = new ArrayList<String>();
    List<IntentFilter.AuthorityEntry> authoritites = new ArrayList<IntentFilter.AuthorityEntry>();
    List<String> categories = new ArrayList<String>();
    int priority;

    @Implementation
    public static IntentFilter create(String action, String dataType) {
        try {
            return new IntentFilter(action, dataType);
        }
        catch (IntentFilter.MalformedMimeTypeException e) {
            throw new RuntimeException("Bad MIME type", e);
        }
    }

    public void __constructor__(String action) {
        this.actions.add(action);
    }

    public void __constructor__(String action, String dataType) {
        this.actions.add(action);
    }

    public void __constructor__(IntentFilter filter) {
        ShadowIntentFilter shadow = Shadows.shadowOf(filter);
        this.actions = new ArrayList<String>(shadow.actions);
        this.schemes = new ArrayList<String>(shadow.schemes);
        this.types = new ArrayList<String>(shadow.types);
        this.authoritites = new ArrayList<IntentFilter.AuthorityEntry>(shadow.authoritites);
        this.categories = new ArrayList<String>(shadow.categories);
        this.priority = shadow.priority;
    }

    @Implementation
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Implementation
    public int getPriority() {
        return this.priority;
    }

    @Implementation
    public void addAction(String action) {
        this.actions.add(action);
    }

    @Implementation
    public String getAction(int index) {
        return this.actions.get(index);
    }

    @Implementation
    public boolean hasAction(String action) {
        return this.actions.contains(action);
    }

    @Implementation
    public int countActions() {
        return this.actions.size();
    }

    @Implementation
    public Iterator<String> actionsIterator() {
        return this.actions.iterator();
    }

    @Implementation
    public boolean matchAction(String action) {
        return this.actions.contains(action);
    }

    @Implementation
    public void addDataAuthority(String host, String port) {
        this.authoritites.add(new IntentFilter.AuthorityEntry(host, port));
    }

    @Implementation
    public final IntentFilter.AuthorityEntry getDataAuthority(int index) {
        return this.authoritites.get(index);
    }

    @Implementation
    public void addDataScheme(String scheme) {
        this.schemes.add(scheme);
    }

    @Implementation
    public String getDataScheme(int index) {
        return this.schemes.get(index);
    }

    @Implementation
    public boolean hasDataScheme(String scheme) {
        return this.schemes.contains(scheme);
    }

    @Implementation
    public void addDataType(String type) throws IntentFilter.MalformedMimeTypeException {
        int slashpos = type.indexOf(47);
        int typelen = type.length();
        if (slashpos > 0 && typelen >= slashpos + 2) {
            if (typelen == slashpos + 2 && type.charAt(slashpos + 1) == '*') {
                String str = type.substring(0, slashpos);
                if (!this.types.contains(str)) {
                    this.types.add(str.intern());
                }
            } else if (!this.types.contains(type)) {
                this.types.add(type.intern());
            }
            return;
        }
        throw new IntentFilter.MalformedMimeTypeException(type);
    }

    @Implementation
    public String getDataType(int index) {
        return this.types.get(index);
    }

    @Implementation
    public boolean hasDataType(String type) {
        List<String> t = this.types;
        if (type == null) {
            return false;
        }
        if (t.contains(type)) {
            return true;
        }
        int typeLength = type.length();
        if (typeLength == 3 && type.equals("*/*")) {
            return !t.isEmpty();
        }
        if (t.contains("*")) {
            return true;
        }
        int slashpos = type.indexOf(47);
        if (slashpos > 0) {
            if (t.contains(type.substring(0, slashpos))) {
                return true;
            }
            if (typeLength == slashpos + 2 && type.charAt(slashpos + 1) == '*') {
                int numTypes = t.size();
                for (int i = 0; i < numTypes; ++i) {
                    String v = t.get(i);
                    if (!type.regionMatches(0, v, 0, slashpos + 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Implementation
    public void addCategory(String category) {
        this.categories.add(category);
    }

    @Implementation
    public boolean hasCategory(String category) {
        return this.categories.contains(category);
    }

    @Implementation
    public Iterator<String> categoriesIterator() {
        return this.categories.iterator();
    }

    @Implementation
    public String getCategory(int index) {
        return this.categories.get(index);
    }

    @Implementation
    public String matchCategories(Set<String> categories) {
        if (categories == null) {
            return null;
        }
        Iterator<String> it = categories.iterator();
        if (this.categories == null) {
            return it.hasNext() ? it.next() : null;
        }
        while (it.hasNext()) {
            String category = it.next();
            if (this.categories.contains(category)) continue;
            return category;
        }
        return null;
    }

    @Implementation
    public final int matchData(String type, String scheme, Uri data) {
        boolean schemeMatch = false;
        if (this.types.isEmpty() && this.schemes.isEmpty()) {
            if (type == null && data == null) {
                return 0x108000;
            }
            return -2;
        }
        if (this.schemes.isEmpty()) {
            if (this.hasDataType(type)) {
                return 0x608000;
            }
            return -1;
        }
        if (this.hasDataScheme(scheme)) {
            if (!this.authoritites.isEmpty() && this.matchDataAuthority(data) == -2) {
                return -2;
            }
        } else {
            return -2;
        }
        schemeMatch = true;
        if (this.types.isEmpty()) {
            if (type != null) {
                return -1;
            }
        } else {
            if (this.hasDataType(type)) {
                return 0x608000;
            }
            return -1;
        }
        return schemeMatch ? 0x208000 : -2;
    }

    @Implementation
    public final int matchDataAuthority(Uri data) {
        for (IntentFilter.AuthorityEntry entry : this.authoritites) {
            if (!entry.getHost().equals(data.getHost())) continue;
            if (entry.getPort() != -1) {
                if (entry.getPort() != data.getPort()) continue;
                return 0x708000;
            }
            return 0x308000;
        }
        return -2;
    }

    @Implementation
    public int hashCode() {
        int result = 13;
        result = 31 * result + this.actions.hashCode();
        result = 31 * result + this.categories.hashCode();
        result = 31 * result + this.schemes.hashCode();
        result = 31 * result + this.authoritites.hashCode();
        result = 31 * result + this.types.hashCode();
        return result;
    }

    @Implements(value=IntentFilter.AuthorityEntry.class)
    public static class ShadowAuthorityEntry {
        private String host;
        private int port;

        public void __constructor__(String host, String port) {
            this.host = host;
            this.port = port == null ? -1 : Integer.parseInt(port);
        }

        @Implementation
        public String getHost() {
            return this.host;
        }

        @Implementation
        public int getPort() {
            return this.port;
        }
    }
}

