/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;
import org.robolectric.util.Join;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Intent.class)
public class ShadowIntent {
    @RealObject
    private Intent realIntent;
    private final Bundle extras = new Bundle();
    private String action;
    private ComponentName componentName;
    private String type;
    private Uri data;
    private int flags;
    private Class<?> intentClass;
    private String packageName;
    private final Set<String> categories = new HashSet<String>();

    public void __constructor__(String action, Uri uri, Context packageContext, Class cls) {
        this.componentName = new ComponentName(packageContext, cls);
        this.data = uri;
        this.intentClass = cls;
        Shadow.invokeConstructor(Intent.class, (Object)this.realIntent, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)action), ReflectionHelpers.ClassParameter.from(Uri.class, (Object)uri), ReflectionHelpers.ClassParameter.from(Context.class, (Object)packageContext), ReflectionHelpers.ClassParameter.from(Class.class, (Object)cls)});
    }

    public void __constructor__(Context packageContext, Class cls) {
        this.componentName = new ComponentName(packageContext, cls);
        this.intentClass = cls;
        Shadow.invokeConstructor(Intent.class, (Object)this.realIntent, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)packageContext), ReflectionHelpers.ClassParameter.from(Class.class, (Object)cls)});
    }

    public void __constructor__(String action, Uri uri) {
        this.action = action;
        this.data = uri;
        Shadow.invokeConstructor(Intent.class, (Object)this.realIntent, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)action), ReflectionHelpers.ClassParameter.from(Uri.class, (Object)uri)});
    }

    public void __constructor__(String action) {
        this.__constructor__(action, null);
        Shadow.invokeConstructor(Intent.class, (Object)this.realIntent, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)action)});
    }

    public void __constructor__(Parcel in) {
        this.__constructor__(in.readString());
        this.data = (Uri)Uri.CREATOR.createFromParcel(in);
        this.type = in.readString();
        this.flags = in.readInt();
        this.packageName = in.readString();
        this.componentName = ComponentName.readFromParcel((Parcel)in);
        int N = in.readInt();
        if (N > 0) {
            for (int i = 0; i < N; ++i) {
                this.categories.add(in.readString());
            }
        }
        this.extras.putAll(in.readBundle());
    }

    @Implementation
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.action);
        Uri.writeToParcel((Parcel)out, (Uri)this.data);
        out.writeString(this.type);
        out.writeInt(this.flags);
        out.writeString(this.packageName);
        ComponentName.writeToParcel((ComponentName)this.componentName, (Parcel)out);
        if (this.categories != null) {
            int N = this.categories.size();
            out.writeInt(N);
            for (String s : this.categories) {
                out.writeString(s);
            }
        } else {
            out.writeInt(0);
        }
        out.writeBundle(this.extras);
    }

    public void __constructor__(Intent intent) {
        ShadowIntent other = Shadows.shadowOf(intent);
        this.extras.putAll(other.extras);
        this.action = other.action;
        this.componentName = other.componentName;
        this.type = other.type;
        this.data = other.data;
        this.flags = other.flags;
        this.intentClass = other.intentClass;
        this.packageName = other.packageName;
        this.categories.addAll(other.categories);
        Shadow.invokeConstructor(Intent.class, (Object)this.realIntent, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Intent.class, (Object)intent)});
    }

    @Implementation
    public static Intent createChooser(Intent target, CharSequence title) {
        Intent intent = new Intent("android.intent.action.CHOOSER");
        intent.putExtra("android.intent.extra.INTENT", (Parcelable)target);
        if (title != null) {
            intent.putExtra("android.intent.extra.TITLE", title);
        }
        return intent;
    }

    @Implementation
    public Intent setAction(String action) {
        this.action = action;
        return this.realIntent;
    }

    @Implementation
    public String getAction() {
        return this.action;
    }

    @Implementation
    public Intent setType(String type) {
        this.type = type;
        this.data = null;
        return this.realIntent;
    }

    @Implementation
    public Intent setDataAndType(Uri data, String type) {
        this.data = data;
        this.type = type;
        return this.realIntent;
    }

    @Implementation
    public String getType() {
        return this.type;
    }

    @Implementation
    public Intent addCategory(String category) {
        this.categories.add(category);
        return this.realIntent;
    }

    @Implementation
    public void removeCategory(String category) {
        this.categories.remove(category);
    }

    @Implementation
    public boolean hasCategory(String category) {
        return this.categories.contains(category);
    }

    @Implementation
    public Set<String> getCategories() {
        return this.categories;
    }

    @Implementation
    public Intent setPackage(String packageName) {
        this.packageName = packageName;
        return this.realIntent;
    }

    @Implementation
    public String getPackage() {
        return this.packageName;
    }

    @Implementation
    public Uri getData() {
        return this.data;
    }

    @Implementation
    public String getScheme() {
        return this.data != null ? this.data.getScheme() : null;
    }

    @Implementation
    public String getDataString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return null;
    }

    @Implementation
    public Intent setClass(Context packageContext, Class<?> cls) {
        this.componentName = new ComponentName(packageContext, cls);
        this.intentClass = cls;
        return this.realIntent;
    }

    @Implementation
    public Intent setClassName(String packageName, String className) {
        this.componentName = new ComponentName(packageName, className);
        try {
            this.intentClass = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.realIntent;
    }

    @Implementation
    public Intent setClassName(Context packageContext, String className) {
        this.componentName = new ComponentName(packageContext.getPackageName(), className);
        return this.realIntent;
    }

    @Implementation
    public Intent setData(Uri data) {
        this.data = data;
        this.type = null;
        return this.realIntent;
    }

    @Implementation
    public int getFlags() {
        return this.flags;
    }

    @Implementation
    public Intent setFlags(int flags) {
        this.flags = flags;
        return this.realIntent;
    }

    @Implementation
    public Intent addFlags(int flags) {
        this.flags |= flags;
        return this.realIntent;
    }

    @Implementation
    public Intent putExtras(Bundle src) {
        this.extras.putAll(src);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtras(Intent src) {
        ShadowIntent srcShadowIntent = Shadows.shadowOf(src);
        this.extras.putAll(srcShadowIntent.extras);
        return this.realIntent;
    }

    @Implementation
    public Bundle getExtras() {
        return this.extras.isEmpty() ? null : new Bundle(this.extras);
    }

    @Implementation
    public Intent putExtra(String key, char value) {
        this.extras.putChar(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, byte value) {
        this.extras.putByte(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, int value) {
        this.extras.putInt(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, double value) {
        this.extras.putDouble(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, short value) {
        this.extras.putShort(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, float value) {
        this.extras.putFloat(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, long value) {
        this.extras.putLong(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, Serializable value) {
        this.extras.putSerializable(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, Parcelable value) {
        this.extras.putParcelable(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, Parcelable[] value) {
        this.extras.putParcelableArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, String value) {
        this.extras.putString(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, String[] value) {
        this.extras.putStringArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, Bundle value) {
        this.extras.putBundle(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, boolean value) {
        this.extras.putBoolean(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, boolean[] value) {
        this.extras.putBooleanArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, char[] value) {
        this.extras.putCharArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, int[] value) {
        this.extras.putIntArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, long[] value) {
        this.extras.putLongArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, float[] value) {
        this.extras.putFloatArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, double[] value) {
        this.extras.putDoubleArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, short[] value) {
        this.extras.putShortArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public char[] getCharArrayExtra(String name) {
        return this.extras.getCharArray(name);
    }

    @Implementation
    public boolean[] getBooleanArrayExtra(String name) {
        return this.extras.getBooleanArray(name);
    }

    @Implementation
    public int[] getIntArrayExtra(String name) {
        return this.extras.getIntArray(name);
    }

    @Implementation
    public long[] getLongArrayExtra(String name) {
        return this.extras.getLongArray(name);
    }

    @Implementation
    public float[] getFloatArrayExtra(String name) {
        return this.extras.getFloatArray(name);
    }

    @Implementation
    public double[] getDoubleArrayExtra(String name) {
        return this.extras.getDoubleArray(name);
    }

    @Implementation
    public short[] getShortArrayExtra(String name) {
        return this.extras.getShortArray(name);
    }

    @Implementation
    public boolean getBooleanExtra(String name, boolean defaultValue) {
        return this.extras.getBoolean(name, defaultValue);
    }

    @Implementation
    public String[] getStringArrayExtra(String name) {
        return this.extras.getStringArray(name);
    }

    @Implementation
    public CharSequence[] getCharSequenceArrayExtra(String name) {
        return this.extras.getCharSequenceArray(name);
    }

    @Implementation
    public ArrayList<CharSequence> getCharSequenceArrayListExtra(String name) {
        return this.extras.getCharSequenceArrayList(name);
    }

    @Implementation
    public Intent putExtra(String key, CharSequence value) {
        this.extras.putCharSequence(key, value);
        return this.realIntent;
    }

    @Implementation
    public CharSequence getCharSequenceExtra(String name) {
        return this.extras.getCharSequence(name);
    }

    @Implementation
    public Intent putExtra(String key, byte[] value) {
        this.extras.putByteArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putStringArrayListExtra(String key, ArrayList<String> value) {
        this.extras.putStringArrayList(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putExtra(String key, CharSequence[] value) {
        this.extras.putCharSequenceArray(key, value);
        return this.realIntent;
    }

    @Implementation
    public Intent putCharSequenceArrayListExtra(String key, ArrayList<CharSequence> value) {
        this.extras.putCharSequenceArrayList(key, value);
        return this.realIntent;
    }

    @Implementation
    public ArrayList<String> getStringArrayListExtra(String name) {
        return this.extras.getStringArrayList(name);
    }

    @Implementation
    public Intent putIntegerArrayListExtra(String key, ArrayList<Integer> value) {
        this.extras.putIntegerArrayList(key, value);
        return this.realIntent;
    }

    @Implementation
    public ArrayList<Integer> getIntegerArrayListExtra(String name) {
        return this.extras.getIntegerArrayList(name);
    }

    @Implementation
    public Intent putParcelableArrayListExtra(String key, ArrayList<Parcelable> value) {
        this.extras.putParcelableArrayList(key, value);
        return this.realIntent;
    }

    @Implementation
    public ArrayList<Parcelable> getParcelableArrayListExtra(String key) {
        return this.extras.getParcelableArrayList(key);
    }

    @Implementation
    public boolean hasExtra(String name) {
        return this.extras.containsKey(name);
    }

    @Implementation
    public String getStringExtra(String name) {
        return this.extras.getString(name);
    }

    @Implementation
    public Parcelable getParcelableExtra(String name) {
        return this.extras.getParcelable(name);
    }

    @Implementation
    public Parcelable[] getParcelableArrayExtra(String name) {
        return this.extras.getParcelableArray(name);
    }

    @Implementation
    public byte getByteExtra(String name, byte defaultValue) {
        return this.extras.getByte(name, defaultValue);
    }

    @Implementation
    public char getCharExtra(String name, char defaultValue) {
        return this.extras.getChar(name, defaultValue);
    }

    @Implementation
    public int getIntExtra(String name, int defaultValue) {
        return this.extras.getInt(name, defaultValue);
    }

    @Implementation
    public long getLongExtra(String name, long defaultValue) {
        return this.extras.getLong(name, defaultValue);
    }

    @Implementation
    public double getDoubleExtra(String name, double defaultValue) {
        return this.extras.getDouble(name, defaultValue);
    }

    @Implementation
    public short getShortExtra(String name, short defaultValue) {
        return this.extras.getShort(name, defaultValue);
    }

    @Implementation
    public Bundle getBundleExtra(String name) {
        return this.extras.getBundle(name);
    }

    @Implementation
    public float getFloatExtra(String name, float defaultValue) {
        return this.extras.getFloat(name, defaultValue);
    }

    @Implementation
    public byte[] getByteArrayExtra(String name) {
        return this.extras.getByteArray(name);
    }

    @Implementation
    public Serializable getSerializableExtra(String name) {
        return this.extras.getSerializable(name);
    }

    @Implementation
    public void removeExtra(String name) {
        this.extras.remove(name);
    }

    @Implementation
    public Intent setComponent(ComponentName componentName) {
        this.componentName = componentName;
        return this.realIntent;
    }

    @Implementation
    public ComponentName getComponent() {
        return this.componentName;
    }

    @Implementation
    public ActivityInfo resolveActivityInfo(PackageManager pm, int flags) {
        ActivityInfo ai = null;
        if (this.componentName != null) {
            try {
                ai = pm.getActivityInfo(this.componentName, flags);
            }
            catch (PackageManager.NameNotFoundException e) {}
        } else {
            ResolveInfo info = pm.resolveActivity(this.realIntent, 0x10000 | flags);
            if (info != null) {
                ai = info.activityInfo;
            }
        }
        return ai;
    }

    @Implementation
    public String toURI() {
        return this.data.toString();
    }

    @Implementation
    public int fillIn(Intent otherIntent, int flags) {
        int changes = 0;
        ShadowIntent other = Shadows.shadowOf(otherIntent);
        if (other.action != null && (this.action == null || (flags & 1) != 0)) {
            this.action = other.action;
            changes |= 1;
        }
        if ((other.data != null || other.type != null) && (this.data == null && this.type == null || (flags & 2) != 0)) {
            this.data = other.data;
            this.type = other.type;
            changes |= 2;
        }
        if (!other.categories.isEmpty() && (this.categories.isEmpty() || (flags & 4) != 0)) {
            this.categories.addAll(other.categories);
            changes |= 4;
        }
        if (other.packageName != null && (this.packageName == null || (flags & 0x10) != 0)) {
            this.packageName = other.packageName;
            changes |= 0x10;
        }
        if (other.componentName != null && (flags & 8) != 0) {
            this.componentName = other.componentName;
            changes |= 8;
        }
        this.extras.putAll(other.extras);
        return changes;
    }

    @Implementation
    public boolean filterEquals(Intent other) {
        if (other == null) {
            return false;
        }
        if (this.getAction() != other.getAction() && (this.getAction() != null ? !this.getAction().equals(other.getAction()) : !other.getAction().equals(this.getAction()))) {
            return false;
        }
        if (this.getData() != other.getData() && (this.getData() != null ? !this.getData().equals((Object)other.getData()) : !other.getData().equals((Object)this.getData()))) {
            return false;
        }
        if (this.getType() != other.getType() && (this.getType() != null ? !this.getType().equals(other.getType()) : !other.getType().equals(this.getType()))) {
            return false;
        }
        if (this.getPackage() != other.getPackage() && (this.getPackage() != null ? !this.getPackage().equals(other.getPackage()) : !other.getPackage().equals(this.getPackage()))) {
            return false;
        }
        if (this.getComponent() != other.getComponent() && (this.getComponent() != null ? !this.getComponent().equals((Object)other.getComponent()) : !other.getComponent().equals((Object)this.getComponent()))) {
            return false;
        }
        return this.getCategories() == other.getCategories() || !(this.getCategories() != null ? !this.getCategories().equals(other.getCategories()) : !other.getCategories().equals(this.getCategories()));
    }

    @Deprecated
    public boolean realIntentEquals(ShadowIntent o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.action != null ? !this.action.equals(o.action) : o.action != null) {
            return false;
        }
        if (this.packageName != null ? !this.packageName.equals(o.packageName) : o.packageName != null) {
            return false;
        }
        if (this.componentName != null ? !this.componentName.equals((Object)o.componentName) : o.componentName != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals((Object)o.data) : o.data != null) {
            return false;
        }
        if (this.extras != null ? !this.extras.equals(o.extras) : o.extras != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(o.type) : o.type != null) {
            return false;
        }
        return !(this.categories != null ? !this.categories.equals(o.categories) : o.categories != null);
    }

    @Implementation
    public int hashCode() {
        int result = this.extras != null ? this.extras.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.categories != null ? this.categories.hashCode() : 0);
        result = 31 * result + this.flags;
        return result;
    }

    @Implementation
    public boolean equals(Object o) {
        if (!(o instanceof Intent)) {
            return false;
        }
        return this.realIntentEquals(Shadows.shadowOf((Intent)o));
    }

    public Class<?> getIntentClass() {
        return this.intentClass;
    }

    @Implementation
    public String toString() {
        return "Intent{" + Join.join((String)", ", (Object[])new Object[]{this.ifWeHave(this.componentName, "componentName"), this.ifWeHave(this.action, "action"), this.ifWeHave(this.extras, "extras"), this.ifWeHave(this.data, "data"), this.ifWeHave(this.type, "type")}) + '}';
    }

    private String ifWeHave(Object o, String name) {
        if (o == null) {
            return null;
        }
        if (o instanceof Map && ((Map)o).isEmpty()) {
            return null;
        }
        return name + "=" + o;
    }

    @Deprecated
    public void setURI(String uri) {
        this.data = Uri.parse((String)uri);
    }
}

