/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.util.TypedValue;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.internal.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Drawable.class)
public class ShadowDrawable {
    private static int defaultIntrinsicWidth = -1;
    private static int defaultIntrinsicHeight = -1;
    static final List<String> corruptStreamSources = new ArrayList<String>();
    @RealObject
    Drawable realDrawable;
    int createdFromResId = -1;
    InputStream createdFromInputStream;
    private int intrinsicWidth = defaultIntrinsicWidth;
    private int intrinsicHeight = defaultIntrinsicHeight;
    private int alpha;
    private boolean wasInvalidated;

    @Implementation
    public static Drawable createFromStream(InputStream is, String srcName) {
        if (corruptStreamSources.contains(srcName)) {
            return null;
        }
        BitmapDrawable drawable = new BitmapDrawable((Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        Shadows.shadowOf((BitmapDrawable)drawable).createdFromInputStream = is;
        Shadows.shadowOf((BitmapDrawable)drawable).drawableCreateFromStreamSource = srcName;
        Shadows.shadowOf(drawable).validate();
        return drawable;
    }

    @Implementation
    public static Drawable createFromResourceStream(Resources res, TypedValue value, InputStream is, String srcName, BitmapFactory.Options opts) {
        if (is == null) {
            return null;
        }
        Rect pad = new Rect();
        if (opts == null) {
            opts = new BitmapFactory.Options();
        }
        opts.inScreenDensity = 160;
        Bitmap bm = BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)opts);
        if (bm != null) {
            byte[] np;
            boolean isNinePatch;
            boolean bl = isNinePatch = srcName != null && srcName.contains(".9.");
            if (isNinePatch) {
                ReflectionHelpers.callInstanceMethod((Object)bm, (String)"setNinePatchChunk", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(byte[].class, (Object)new byte[0])});
            }
            if ((np = bm.getNinePatchChunk()) == null || !NinePatch.isNinePatchChunk((byte[])np)) {
                np = null;
                pad = null;
            }
            if (np != null) {
                return new NinePatchDrawable(res, bm, np, pad, srcName);
            }
            return new BitmapDrawable(res, bm);
        }
        return null;
    }

    @Implementation
    public static Drawable createFromPath(String pathName) {
        BitmapDrawable drawable = new BitmapDrawable((Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        Shadows.shadowOf((BitmapDrawable)drawable).drawableCreateFromPath = pathName;
        Shadows.shadowOf(drawable).validate();
        return drawable;
    }

    public static Drawable createFromResourceId(int resourceId) {
        Bitmap bitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        Shadows.shadowOf((Bitmap)bitmap).createdFromResId = resourceId;
        BitmapDrawable drawable = new BitmapDrawable(bitmap);
        Shadows.shadowOf(drawable).validate();
        Shadows.shadowOf((BitmapDrawable)drawable).createdFromResId = resourceId;
        return drawable;
    }

    @Implementation
    public int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    @Implementation
    public int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public static void addCorruptStreamSource(String src) {
        corruptStreamSources.add(src);
    }

    @Resetter
    public static void clearCorruptStreamSources() {
        corruptStreamSources.clear();
    }

    public static void setDefaultIntrinsicWidth(int defaultIntrinsicWidth) {
        ShadowDrawable.defaultIntrinsicWidth = defaultIntrinsicWidth;
    }

    public static void setDefaultIntrinsicHeight(int defaultIntrinsicHeight) {
        ShadowDrawable.defaultIntrinsicHeight = defaultIntrinsicHeight;
    }

    public void setIntrinsicWidth(int intrinsicWidth) {
        this.intrinsicWidth = intrinsicWidth;
    }

    public void setIntrinsicHeight(int intrinsicHeight) {
        this.intrinsicHeight = intrinsicHeight;
    }

    public InputStream getInputStream() {
        return this.createdFromInputStream;
    }

    @Implementation
    public boolean equals(Object o) {
        if (this.realDrawable == o) {
            return true;
        }
        if (o == null || this.realDrawable.getClass() != o.getClass()) {
            return false;
        }
        ShadowDrawable that = Shadows.shadowOf((Drawable)o);
        if (this.intrinsicHeight != that.intrinsicHeight) {
            return false;
        }
        if (this.intrinsicWidth != that.intrinsicWidth) {
            return false;
        }
        Rect bounds = this.realDrawable.getBounds();
        Rect thatBounds = that.realDrawable.getBounds();
        return !(bounds != null ? !bounds.equals((Object)thatBounds) : thatBounds != null);
    }

    @Implementation
    public int hashCode() {
        Rect bounds = this.realDrawable.getBounds();
        int result = bounds != null ? bounds.hashCode() : 0;
        result = 31 * result + this.intrinsicWidth;
        result = 31 * result + this.intrinsicHeight;
        return result;
    }

    @Implementation
    public void setAlpha(int alpha) {
        this.alpha = alpha;
        ((Drawable)Shadow.directlyOn((Object)this.realDrawable, Drawable.class)).setAlpha(alpha);
    }

    @Implementation
    public void invalidateSelf() {
        this.wasInvalidated = true;
        Shadow.directlyOn((Object)this.realDrawable, Drawable.class, (String)"invalidateSelf", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    public int getAlpha() {
        return this.alpha;
    }

    @Deprecated
    public static void reset() {
        ShadowDrawable.clearCorruptStreamSources();
    }

    public int getCreatedFromResId() {
        return this.createdFromResId;
    }

    public boolean wasInvalidated() {
        return this.wasInvalidated;
    }

    public void validate() {
        this.wasInvalidated = false;
    }
}

