/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.webkit.CookieManager;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BestMatchSpec;
import org.apache.http.message.BasicHeader;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=CookieManager.class)
public class ShadowCookieManager {
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String[] COOKIE_ATTRS_NOT_STRICT = new String[]{"Expires", "expires"};
    private static final List<Cookie> emtpyCookieList = new ArrayList<Cookie>();
    private static CookieManager cookieManager;
    private CookieStore store = new BasicCookieStore();
    private boolean accept;
    private boolean flushed;

    @Resetter
    public static void resetCookies() {
        cookieManager = null;
    }

    @Implementation
    public static CookieManager getInstance() {
        if (cookieManager == null) {
            cookieManager = (CookieManager)ReflectionHelpers.callConstructor(CookieManager.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        return cookieManager;
    }

    @Implementation
    public void setCookie(String url, String value) {
        List<Cookie> cookies = this.parseCookies(url, value);
        for (Cookie cookie : cookies) {
            this.store.addCookie(cookie);
        }
    }

    @Implementation
    public String getCookie(String url) {
        List<Cookie> matchedCookies;
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (url.startsWith(".")) {
            matchedCookies = this.filter(url.substring(1));
        } else if (url.contains("//.")) {
            matchedCookies = this.filter(url.substring(url.indexOf("//.") + 3));
        } else {
            CookieOrigin origin = this.getOrigin(url);
            matchedCookies = this.filter(origin);
        }
        if (matchedCookies.isEmpty()) {
            return null;
        }
        StringBuffer cookieHeaderValue = new StringBuffer();
        int n = matchedCookies.size();
        for (int i = 0; i < n; ++i) {
            Cookie cookie = matchedCookies.get(i);
            if (i > 0) {
                cookieHeaderValue.append("; ");
            }
            cookieHeaderValue.append(cookie.getName());
            String value = cookie.getValue();
            if (value == null) continue;
            cookieHeaderValue.append("=");
            cookieHeaderValue.append(value);
        }
        return cookieHeaderValue.toString();
    }

    private List<Cookie> filter(CookieOrigin origin) {
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        Date now = new Date();
        CookieSpec cookieSpec = this.createSpec();
        for (Cookie cookie : this.store.getCookies()) {
            if (cookie.isExpired(now) || !cookieSpec.match(cookie, origin)) continue;
            matchedCookies.add(cookie);
        }
        return matchedCookies;
    }

    private List<Cookie> filter(String domain) {
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        Date now = new Date();
        for (Cookie cookie : this.store.getCookies()) {
            if (cookie.isExpired(now) || !cookie.getDomain().endsWith(domain)) continue;
            matchedCookies.add(cookie);
        }
        return matchedCookies;
    }

    @Implementation
    public void setAcceptCookie(boolean accept) {
        this.accept = accept;
    }

    @Implementation
    public boolean acceptCookie() {
        return this.accept;
    }

    @Implementation
    public void removeAllCookie() {
        this.store.clear();
    }

    @Implementation
    public void removeExpiredCookie() {
        this.store.clearExpired(new Date());
    }

    @Implementation
    public boolean hasCookies() {
        return !this.store.getCookies().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public void removeSessionCookie() {
        CookieStore cookieStore = this.store;
        synchronized (cookieStore) {
            this.clearAndAddPersistentCookies();
        }
    }

    @Implementation
    public void flush() {
        this.flushed = true;
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    public void reset() {
        this.flushed = false;
    }

    private void clearAndAddPersistentCookies() {
        ArrayList cookies = new ArrayList(this.store.getCookies());
        this.store.clear();
        for (Cookie cookie : cookies) {
            if (!cookie.isPersistent()) continue;
            this.store.addCookie(cookie);
        }
    }

    private List<Cookie> parseCookies(String url, String cookieHeader) {
        CookieOrigin origin = this.getOrigin(url);
        BasicHeader header = new BasicHeader("Set-Cookie", cookieHeader);
        int attrIndex = 0;
        while (true) {
            try {
                CookieSpec cookieSpec = this.createSpec();
                return cookieSpec.parse((Header)header, origin);
            }
            catch (MalformedCookieException e) {
                int indexOfAttrTitle = cookieHeader.indexOf(COOKIE_ATTRS_NOT_STRICT[attrIndex]);
                if (indexOfAttrTitle == -1) continue;
                cookieHeader = cookieHeader.substring(0, indexOfAttrTitle);
                header = new BasicHeader("Set-Cookie", cookieHeader);
                if (++attrIndex <= COOKIE_ATTRS_NOT_STRICT.length) continue;
                return emtpyCookieList;
            }
            break;
        }
    }

    private CookieSpec createSpec() {
        return new BestMatchSpec();
    }

    private CookieOrigin getOrigin(String url) {
        URI uri;
        if (!url.startsWith(HTTP) && !url.startsWith(HTTPS)) {
            url = HTTP + url;
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("wrong URL :" + url, e);
        }
        int port = uri.getPort() < 0 ? 80 : uri.getPort();
        boolean secure = "https".equals(uri.getScheme());
        return new CookieOrigin(uri.getHost(), port, uri.getPath(), secure);
    }
}

