/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.AccountManager;
import android.content.Context;
import android.os.FileUtils;
import android.os.Handler;
import android.print.IPrintManager;
import android.view.Display;
import android.view.accessibility.AccessibilityManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;
import org.robolectric.shadows.RoboLayoutInflater;
import org.robolectric.shadows.ShadowContext;
import org.robolectric.util.ReflectionHelpers;

@Implements(className="android.app.ContextImpl")
public class ShadowContextImpl
extends ShadowContext {
    public static final String CLASS_NAME = "android.app.ContextImpl";
    private static final Map<String, String> SYSTEM_SERVICE_MAP = new HashMap<String, String>();
    @RealObject
    private Context realObject;
    private Map<String, Object> systemServices = new HashMap<String, Object>();

    @Implementation
    public File validateFilePath(String name, boolean createDirectory) {
        File dir;
        File f = new File(name);
        if (f.isAbsolute()) {
            dir = f.getParentFile();
        } else {
            dir = (File)Shadow.directlyOn((Object)this.realObject, (String)CLASS_NAME, (String)"getDatabasesDir", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            f = (File)Shadow.directlyOn((Object)this.realObject, (String)CLASS_NAME, (String)"makeFilename", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(File.class, (Object)dir), ReflectionHelpers.ClassParameter.from(String.class, (Object)name)});
        }
        if (createDirectory && !dir.isDirectory() && dir.mkdir()) {
            FileUtils.setPermissions((String)dir.getPath(), (int)505, (int)-1, (int)-1);
        }
        return f;
    }

    @Implementation
    public Object getSystemService(String name) {
        if (name.equals("layout_inflater")) {
            return new RoboLayoutInflater((Context)RuntimeEnvironment.application);
        }
        Object service = this.systemServices.get(name);
        if (service == null) {
            String serviceClassName = SYSTEM_SERVICE_MAP.get(name);
            if (serviceClassName == null) {
                System.err.println("WARNING: unknown service " + name);
                return null;
            }
            try {
                Class<?> clazz = Class.forName(serviceClassName);
                if (serviceClassName.equals("android.app.SearchManager") || serviceClassName.equals("android.app.ActivityManager") || serviceClassName.equals("android.app.admin.DevicePolicyManager")) {
                    service = ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application), ReflectionHelpers.ClassParameter.from(Handler.class, null)});
                } else if (serviceClassName.equals("android.os.storage.StorageManager")) {
                    service = ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                } else if (serviceClassName.equals("android.nfc.NfcManager")) {
                    service = ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application)});
                } else if (serviceClassName.equals("android.hardware.display.DisplayManager")) {
                    service = ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application)});
                } else if (serviceClassName.equals("android.view.accessibility.AccessibilityManager")) {
                    service = AccessibilityManager.getInstance((Context)this.realObject);
                } else if (serviceClassName.equals("android.view.WindowManagerImpl")) {
                    Display display = (Display)Shadow.newInstanceOf(Display.class);
                    service = ReflectionHelpers.callConstructor(Class.forName("android.view.WindowManagerImpl"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Display.class, (Object)display)});
                } else {
                    service = serviceClassName.equals("android.accounts.AccountManager") ? AccountManager.get(null) : (serviceClassName.equals("android.print.PrintManager") ? ReflectionHelpers.callConstructor(Class.forName("android.print.PrintManager"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application), ReflectionHelpers.ClassParameter.from(IPrintManager.class, null), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)-1), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)-1)}) : Shadow.newInstanceOf(clazz));
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.systemServices.put(name, service);
        }
        return service;
    }

    public void setSystemService(String key, Object service) {
        this.systemServices.put(key, service);
    }

    static {
        SYSTEM_SERVICE_MAP.put("window", "android.view.WindowManagerImpl");
        SYSTEM_SERVICE_MAP.put("clipboard", "android.content.ClipboardManager");
        SYSTEM_SERVICE_MAP.put("sensor", "org.robolectric.fakes.RoboSensorManager");
        SYSTEM_SERVICE_MAP.put("vibrator", "org.robolectric.fakes.RoboVibrator");
        SYSTEM_SERVICE_MAP.put("layout_inflater", "android.view.LayoutInflater");
        SYSTEM_SERVICE_MAP.put("activity", "android.app.ActivityManager");
        SYSTEM_SERVICE_MAP.put("power", "android.os.PowerManager");
        SYSTEM_SERVICE_MAP.put("alarm", "android.app.AlarmManager");
        SYSTEM_SERVICE_MAP.put("notification", "android.app.NotificationManager");
        SYSTEM_SERVICE_MAP.put("keyguard", "android.app.KeyguardManager");
        SYSTEM_SERVICE_MAP.put("location", "android.location.LocationManager");
        SYSTEM_SERVICE_MAP.put("search", "android.app.SearchManager");
        SYSTEM_SERVICE_MAP.put("storage", "android.os.storage.StorageManager");
        SYSTEM_SERVICE_MAP.put("connectivity", "android.net.ConnectivityManager");
        SYSTEM_SERVICE_MAP.put("wifi", "android.net.wifi.WifiManager");
        SYSTEM_SERVICE_MAP.put("audio", "android.media.AudioManager");
        SYSTEM_SERVICE_MAP.put("phone", "android.telephony.TelephonyManager");
        SYSTEM_SERVICE_MAP.put("input_method", "android.view.inputmethod.InputMethodManager");
        SYSTEM_SERVICE_MAP.put("uimode", "android.app.UiModeManager");
        SYSTEM_SERVICE_MAP.put("download", "android.app.DownloadManager");
        SYSTEM_SERVICE_MAP.put("textservices", "android.view.textservice.TextServicesManager");
        SYSTEM_SERVICE_MAP.put("device_policy", "android.app.admin.DevicePolicyManager");
        SYSTEM_SERVICE_MAP.put("dropbox", "android.os.DropBoxManager");
        SYSTEM_SERVICE_MAP.put("media_router", "android.media.MediaRouter");
        SYSTEM_SERVICE_MAP.put("display", "android.hardware.display.DisplayManager");
        SYSTEM_SERVICE_MAP.put("user", "android.os.UserManager");
        SYSTEM_SERVICE_MAP.put("accessibility", "android.view.accessibility.AccessibilityManager");
        SYSTEM_SERVICE_MAP.put("account", "android.accounts.AccountManager");
        SYSTEM_SERVICE_MAP.put("nfc", "android.nfc.NfcManager");
        SYSTEM_SERVICE_MAP.put("print", "android.print.PrintManager");
    }

    @Implements(className="android.app.ContextImpl$ServiceFetcher", looseSignatures=true)
    public static class ShadowServiceFetcher {
        public static final String CLASS_NAME = "android.app.ContextImpl$ServiceFetcher";

        @Implementation
        public Object createService(Object ctx) {
            return null;
        }
    }
}

