/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowApplication;

@Implements(value=BluetoothAdapter.class)
public class ShadowBluetoothAdapter {
    private static final int ADDRESS_LENGTH = 17;
    private Set<BluetoothDevice> bondedDevices = new HashSet<BluetoothDevice>();
    private Set<BluetoothAdapter.LeScanCallback> leScanCallbacks = new HashSet<BluetoothAdapter.LeScanCallback>();
    private boolean isDiscovering;
    private String address;
    private boolean enabled;
    private int state;

    @Implementation
    public static BluetoothAdapter getDefaultAdapter() {
        return (BluetoothAdapter)ShadowApplication.getInstance().getBluetoothAdapter();
    }

    @Implementation
    public Set<BluetoothDevice> getBondedDevices() {
        return Collections.unmodifiableSet(this.bondedDevices);
    }

    public void setBondedDevices(Set<BluetoothDevice> bluetoothDevices) {
        this.bondedDevices = bluetoothDevices;
    }

    @Implementation
    public boolean startDiscovery() {
        this.isDiscovering = true;
        return true;
    }

    @Implementation
    public boolean cancelDiscovery() {
        this.isDiscovering = false;
        return true;
    }

    @Implementation
    public boolean startLeScan(BluetoothAdapter.LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    @Implementation
    public boolean startLeScan(UUID[] serviceUuids, BluetoothAdapter.LeScanCallback callback) {
        this.leScanCallbacks.add(callback);
        return true;
    }

    @Implementation
    public void stopLeScan(BluetoothAdapter.LeScanCallback callback) {
        this.leScanCallbacks.remove(callback);
    }

    public Set<BluetoothAdapter.LeScanCallback> getLeScanCallbacks() {
        return Collections.unmodifiableSet(this.leScanCallbacks);
    }

    public BluetoothAdapter.LeScanCallback getSingleLeScanCallback() {
        if (this.leScanCallbacks.size() != 1) {
            throw new IllegalStateException("There are " + this.leScanCallbacks.size() + " callbacks");
        }
        return this.leScanCallbacks.iterator().next();
    }

    @Implementation
    public boolean isDiscovering() {
        return this.isDiscovering;
    }

    @Implementation
    public boolean isEnabled() {
        return this.enabled;
    }

    @Implementation
    public boolean enable() {
        this.enabled = true;
        return true;
    }

    @Implementation
    public boolean disable() {
        this.enabled = false;
        return true;
    }

    @Implementation
    public String getAddress() {
        return this.address;
    }

    @Implementation
    public int getState() {
        return this.state;
    }

    @Implementation
    public static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

