/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.Application;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.os.Looper;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.ShadowsAdapter;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.res.ResourceLoader;
import org.robolectric.shadows.ShadowActivity;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowLog;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowResources;
import org.robolectric.util.Scheduler;

public class CoreShadowsAdapter
implements ShadowsAdapter {
    public Scheduler getBackgroundScheduler() {
        return ShadowApplication.getInstance().getBackgroundThreadScheduler();
    }

    public ShadowsAdapter.ShadowActivityAdapter getShadowActivityAdapter(Activity component) {
        final ShadowActivity shadow = Shadows.shadowOf(component);
        return new ShadowsAdapter.ShadowActivityAdapter(){

            public void setTestApplication(Application application) {
                shadow.setTestApplication(application);
            }

            public void setThemeFromManifest() {
                shadow.setThemeFromManifest();
            }
        };
    }

    public ShadowsAdapter.ShadowLooperAdapter getMainLooper() {
        final ShadowLooper shadow = Shadows.shadowOf(Looper.getMainLooper());
        return new ShadowsAdapter.ShadowLooperAdapter(){

            public void runPaused(Runnable runnable) {
                shadow.runPaused(runnable);
            }
        };
    }

    public String getShadowActivityThreadClassName() {
        return "android.app.ActivityThread";
    }

    public void prepareShadowApplicationWithExistingApplication(Application application) {
        ShadowApplication roboShadow = Shadows.shadowOf(RuntimeEnvironment.application);
        ShadowApplication testShadow = Shadows.shadowOf(application);
        testShadow.bind(roboShadow.getAppManifest(), roboShadow.getResourceLoader());
        testShadow.callAttachBaseContext(RuntimeEnvironment.application.getBaseContext());
    }

    public ShadowsAdapter.ShadowApplicationAdapter getApplicationAdapter(Activity component) {
        final ShadowApplication shadow = Shadows.shadowOf(component.getApplication());
        return new ShadowsAdapter.ShadowApplicationAdapter(){

            public AndroidManifest getAppManifest() {
                return shadow.getAppManifest();
            }

            public ResourceLoader getResourceLoader() {
                return shadow.getResourceLoader();
            }
        };
    }

    public void setupLogging() {
        ShadowLog.setupLogging();
    }

    public String getShadowContextImplClassName() {
        return "android.app.ContextImpl";
    }

    public void setSystemResources(ResourceLoader systemResourceLoader) {
        ShadowResources.setSystemResources(systemResourceLoader);
    }

    public void overrideQualifiers(Configuration configuration, String qualifiers) {
        Shadows.shadowOf(configuration).overrideQualifiers(qualifiers);
    }

    public void bind(Application application, AndroidManifest appManifest, ResourceLoader resourceLoader) {
        Shadows.shadowOf(application).bind(appManifest, resourceLoader);
    }

    public void setPackageName(Application application, String packageName) {
        Shadows.shadowOf(application).setPackageName(packageName);
    }

    public void setAssetsQualifiers(AssetManager assets, String qualifiers) {
        Shadows.shadowOf(assets).setQualifiers(qualifiers);
    }

    public ResourceLoader getResourceLoader() {
        return ShadowApplication.getInstance().getResourceLoader();
    }
}

