/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadow.api;

import org.robolectric.internal.IShadow;
import org.robolectric.util.ReflectionHelpers;

public class Shadow {
    private static IShadow SHADOW_IMPL;

    public static <T> T extract(Object instance) {
        return SHADOW_IMPL.extract(instance);
    }

    public static <T> T newInstanceOf(Class<T> clazz) {
        return SHADOW_IMPL.newInstanceOf(clazz);
    }

    public static Object newInstanceOf(String className) {
        try {
            Class<?> aClass = Shadow.class.getClassLoader().loadClass(className);
            return SHADOW_IMPL.newInstanceOf(aClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz, Class[] parameterTypes, Object[] params) {
        return SHADOW_IMPL.newInstance(clazz, parameterTypes, params);
    }

    @Deprecated
    public static <T> T directlyOn(T shadowedObject, Class<T> clazz) {
        return SHADOW_IMPL.directlyOn(shadowedObject, clazz);
    }

    public static <R> R directlyOn(Object shadowedObject, String clazzName, String methodName, ReflectionHelpers.ClassParameter ... paramValues) {
        return SHADOW_IMPL.directlyOn(shadowedObject, clazzName, methodName, paramValues);
    }

    public static <R, T> R directlyOn(T shadowedObject, Class<T> clazz, String methodName, ReflectionHelpers.ClassParameter ... paramValues) {
        return SHADOW_IMPL.directlyOn(shadowedObject, clazz, methodName, paramValues);
    }

    public static <R, T> R directlyOn(Class<T> clazz, String methodName, ReflectionHelpers.ClassParameter ... paramValues) {
        return SHADOW_IMPL.directlyOn(clazz, methodName, paramValues);
    }

    public static <R> R invokeConstructor(Class<? extends R> clazz, R instance, ReflectionHelpers.ClassParameter ... paramValues) {
        return SHADOW_IMPL.invokeConstructor(clazz, instance, paramValues);
    }

    public static String directMethodName(String className, String methodName) {
        return SHADOW_IMPL.directMethodName(className, methodName);
    }

    public static void directInitialize(Class<?> clazz) {
        SHADOW_IMPL.directInitialize(clazz);
    }

    static {
        try {
            SHADOW_IMPL = Class.forName("org.robolectric.internal.bytecode.ShadowImpl").asSubclass(IShadow.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

