/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import org.robolectric.internal.IShadow;
import org.robolectric.internal.bytecode.ProxyMaker;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.robolectric.util.ReflectionHelpers;

public class ShadowImpl
implements IShadow {
    private final ProxyMaker PROXY_MAKER = new ProxyMaker(new ProxyMaker.MethodMapper(){

        @Override
        public String getName(String className, String methodName) {
            return ShadowImpl.this.directMethodName(className, methodName);
        }
    });

    public <T> T extract(Object instance) {
        return (T)((ShadowedObject)instance).$$robo$getData();
    }

    public <T> T newInstanceOf(Class<T> clazz) {
        return (T)ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public <T> T newInstance(Class<T> clazz, Class[] parameterTypes, Object[] params) {
        return (T)ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])ReflectionHelpers.ClassParameter.fromComponentLists((Class[])parameterTypes, (Object[])params));
    }

    public <T> T directlyOn(T shadowedObject, Class<T> clazz) {
        return this.createProxy(shadowedObject, clazz);
    }

    private <T> T createProxy(T shadowedObject, Class<T> clazz) {
        try {
            return this.PROXY_MAKER.createProxy(clazz, shadowedObject);
        }
        catch (Exception e) {
            throw new RuntimeException("error creating direct call proxy for " + clazz, e);
        }
    }

    public <R> R directlyOn(Object shadowedObject, String clazzName, String methodName, ReflectionHelpers.ClassParameter ... paramValues) {
        try {
            Class<?> aClass = shadowedObject.getClass().getClassLoader().loadClass(clazzName);
            return this.directlyOn(shadowedObject, aClass, methodName, paramValues);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <R, T> R directlyOn(T shadowedObject, Class<T> clazz, String methodName, ReflectionHelpers.ClassParameter ... paramValues) {
        String directMethodName = this.directMethodName(clazz.getName(), methodName);
        return (R)ReflectionHelpers.callInstanceMethod(clazz, shadowedObject, (String)directMethodName, (ReflectionHelpers.ClassParameter[])paramValues);
    }

    public <R, T> R directlyOn(Class<T> clazz, String methodName, ReflectionHelpers.ClassParameter ... paramValues) {
        String directMethodName = this.directMethodName(clazz.getName(), methodName);
        return (R)ReflectionHelpers.callStaticMethod(clazz, (String)directMethodName, (ReflectionHelpers.ClassParameter[])paramValues);
    }

    public <R> R invokeConstructor(Class<? extends R> clazz, R instance, ReflectionHelpers.ClassParameter ... paramValues) {
        String directMethodName = this.directMethodName(clazz.getName(), "__constructor__");
        return (R)ReflectionHelpers.callInstanceMethod(clazz, instance, (String)directMethodName, (ReflectionHelpers.ClassParameter[])paramValues);
    }

    public String directMethodName(String className, String methodName) {
        return "$$robo$$" + className.replace('.', '_').replace('$', '_') + "$" + methodName;
    }
}

