/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResBunch;
import org.robolectric.res.ResBundle;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourceLoader;
import org.robolectric.res.TypedResource;
import org.robolectric.res.builder.XmlBlock;

abstract class XResourceLoader
extends ResourceLoader {
    final ResBunch data = new ResBunch();
    final ResBundle<XmlBlock> xmlDocuments = new ResBundle();
    final ResBundle<FsFile> rawResources = new ResBundle();
    private final ResourceIndex resourceIndex;
    private boolean isInitialized = false;

    XResourceLoader(ResourceIndex resourceIndex) {
        this.resourceIndex = resourceIndex;
    }

    abstract void doInitialize();

    synchronized void initialize() {
        if (this.isInitialized) {
            return;
        }
        this.doInitialize();
        this.isInitialized = true;
        this.makeImmutable();
    }

    private void makeImmutable() {
        this.data.makeImmutable();
        this.xmlDocuments.makeImmutable();
        this.rawResources.makeImmutable();
    }

    @Override
    public TypedResource getValue(@NotNull ResName resName, String qualifiers) {
        this.initialize();
        ResBundle.Value<TypedResource> value = this.data.getValue(resName, qualifiers);
        return value == null ? null : value.getValue();
    }

    @Override
    public XmlBlock getXml(ResName resName, String qualifiers) {
        this.initialize();
        return this.xmlDocuments.get(resName, qualifiers);
    }

    @Override
    public InputStream getRawValue(ResName resName) {
        this.initialize();
        FsFile file = this.rawResources.get(resName, "");
        try {
            return file == null ? null : file.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResourceIndex getResourceIndex() {
        return this.resourceIndex;
    }

    @Override
    public void receive(ResourceLoader.Visitor visitor) {
        this.initialize();
        this.data.receive(visitor);
    }
}

