/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

public class StringResources {
    private static final int CODE_POINT_LENGTH = 4;

    public static String escape(String text) {
        text = text.length() > 1 && text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"' ? text.substring(1, text.length() - 1) : text.replaceAll("\\\\(['\"])", "$1");
        return text;
    }

    public static String proccessStringResources(String inputValue) {
        return StringResources.escape(StringResources.convertCodePoints(inputValue.trim().replace("\\n", String.valueOf('\n')).replace("\\t", String.valueOf('\t'))));
    }

    private static String convertCodePoints(String src) {
        String[] tokens = src.split("\\\\u");
        StringBuilder retval = new StringBuilder(tokens[0]);
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].length() < 4) {
                throw new IllegalArgumentException("Too short code point: \\u" + tokens[i]);
            }
            String codePoint = tokens[i].substring(0, 4);
            try {
                retval.append(Character.toChars(Integer.valueOf(codePoint, 16))).append(tokens[i].substring(4));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid code point: \\u" + codePoint, e);
            }
        }
        return retval.toString();
    }
}

