/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.FsFile;

public class ResourcePath {
    private final Class<?> rClass;
    private final String packageName;
    private final FsFile resourceBase;
    private final FsFile assetsDir;
    private final Class<?> internalRClass;

    public ResourcePath(Class<?> rClass, String packageName, FsFile resourceBase, FsFile assetsDir) {
        this(rClass, packageName, resourceBase, assetsDir, null);
    }

    public ResourcePath(Class<?> rClass, String packageName, FsFile resourceBase, FsFile assetsDir, Class<?> internalRClass) {
        this.rClass = rClass;
        this.packageName = packageName;
        this.resourceBase = resourceBase;
        this.assetsDir = assetsDir;
        this.internalRClass = internalRClass;
    }

    public Class<?> getRClass() {
        return this.rClass;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public FsFile getResourceBase() {
        return this.resourceBase;
    }

    public FsFile getAssetsDir() {
        return this.assetsDir;
    }

    public Class<?> getInternalRClass() {
        return this.internalRClass;
    }

    public String toString() {
        return "ResourcePath{package=" + this.getPackageName() + ", path=" + this.resourceBase + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePath that = (ResourcePath)o;
        if (this.rClass != null ? !this.rClass.equals(that.rClass) : that.rClass != null) {
            return false;
        }
        if (this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null) {
            return false;
        }
        if (this.resourceBase != null ? !this.resourceBase.equals(that.resourceBase) : that.resourceBase != null) {
            return false;
        }
        if (this.assetsDir != null ? !this.assetsDir.equals(that.assetsDir) : that.assetsDir != null) {
            return false;
        }
        return this.internalRClass != null ? this.internalRClass.equals(that.internalRClass) : that.internalRClass == null;
    }

    public int hashCode() {
        int result = this.rClass != null ? this.rClass.hashCode() : 0;
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        result = 31 * result + (this.resourceBase != null ? this.resourceBase.hashCode() : 0);
        result = 31 * result + (this.assetsDir != null ? this.assetsDir.hashCode() : 0);
        result = 31 * result + (this.internalRClass != null ? this.internalRClass.hashCode() : 0);
        return result;
    }
}

