/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.StyleData;
import org.robolectric.res.TypedResource;
import org.robolectric.res.builder.XmlBlock;

public abstract class ResourceLoader {
    public abstract TypedResource getValue(@NotNull ResName var1, String var2);

    public TypedResource getValue(int resId, String qualifiers) {
        ResName resName = this.getResourceIndex().getResName(resId);
        return resName != null ? this.getValue(resName, qualifiers) : null;
    }

    public abstract XmlBlock getXml(ResName var1, String var2);

    public abstract InputStream getRawValue(ResName var1);

    public InputStream getRawValue(int resId) {
        return this.getRawValue(this.getResourceIndex().getResName(resId));
    }

    public boolean hasValue(ResName resName, String qualifiers) {
        return this.getValue(resName, qualifiers) != null || this.getXml(resName, qualifiers) != null || this.getRawValue(resName) != null;
    }

    public abstract ResourceIndex getResourceIndex();

    public abstract boolean providesFor(String var1);

    @NotNull
    public List<TypedResource> grep(String regex) {
        return this.grep(Pattern.compile(regex));
    }

    @NotNull
    public List<TypedResource> grep(final Pattern pattern) {
        final ArrayList<TypedResource> matches = new ArrayList<TypedResource>();
        this.receive(new Visitor<TypedResource>(){

            @Override
            public void visit(ResName resName, List<TypedResource> typedResources) {
                boolean match = pattern.matcher(resName.getFullyQualifiedName()).find();
                if (!match && resName.type.equals("style")) {
                    for (TypedResource typedResource : typedResources) {
                        TypedResource style = typedResource;
                        if (!((StyleData)style.getData()).grep(pattern)) continue;
                        match = true;
                        break;
                    }
                }
                if (match) {
                    for (TypedResource typedResource : typedResources) {
                        matches.add(typedResource);
                    }
                }
            }
        });
        return matches;
    }

    public abstract void receive(Visitor var1);

    public static interface Visitor<T> {
        public void visit(ResName var1, List<T> var2);
    }
}

