/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourcePath;

public class ResourceExtractor
extends ResourceIndex {
    private static final Logger LOGGER = Logger.getLogger(ResourceExtractor.class.getName());
    private final String packageName;
    private Integer maxUsedInt = null;

    public ResourceExtractor(ResourcePath resourcePath) {
        this.packageName = resourcePath.getPackageName();
        if (resourcePath.getRClass() != null) {
            this.gatherResourceIdsAndNames(resourcePath.getRClass(), this.packageName);
        }
        if (resourcePath.getInternalRClass() != null) {
            this.gatherResourceIdsAndNames(resourcePath.getInternalRClass(), this.packageName);
        }
    }

    private void gatherResourceIdsAndNames(Class<?> rClass, String packageName) {
        for (Class<?> innerClass : rClass.getClasses()) {
            for (Field field : innerClass.getDeclaredFields()) {
                int id;
                if (!field.getType().equals(Integer.TYPE) || !Modifier.isStatic(field.getModifiers())) continue;
                String section = innerClass.getSimpleName();
                try {
                    id = field.getInt(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (section.equals("styleable")) continue;
                String fieldName = field.getName();
                ResName resName = new ResName(packageName, section, fieldName);
                this.resourceNameToId.put(resName, id);
                this.resourceIdToResName.put(id, resName);
            }
        }
    }

    @Override
    public synchronized Integer getResourceId(ResName resName) {
        Integer id = (Integer)this.resourceNameToId.get(resName);
        if (id == null && ("android".equals(resName.packageName) || "".equals(resName.packageName))) {
            if (this.maxUsedInt == null) {
                this.maxUsedInt = this.resourceIdToResName.isEmpty() ? 0 : (Integer)Collections.max(this.resourceIdToResName.keySet());
            }
            id = this.maxUsedInt = Integer.valueOf(this.maxUsedInt + 1);
            this.resourceNameToId.put(resName, id);
            this.resourceIdToResName.put(id, resName);
            LOGGER.fine("no id mapping found for " + resName.getFullyQualifiedName() + "; assigning ID #0x" + Integer.toHexString(id));
        }
        return id;
    }

    @Override
    public synchronized ResName getResName(int resourceId) {
        return (ResName)this.resourceIdToResName.get(resourceId);
    }

    @Override
    public Collection<String> getPackages() {
        return Collections.singletonList(this.packageName);
    }

    public String toString() {
        return "ResourceExtractor{package=" + this.packageName + '}';
    }
}

