/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.res.Qualifiers;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceLoader;
import org.robolectric.res.XmlLoader;

public class ResBundle<T> {
    private final ResMap<T> valuesMap = new ResMap();
    private final ResMap<List<T>> valuesArrayMap = new ResMap();
    private String overrideNamespace;

    public void put(String attrType, String name, T value, XmlLoader.XmlContext xmlContext) {
        ResName resName = new ResName(this.maybeOverride(xmlContext.packageName), attrType, name);
        List<Value<T>> values = this.valuesMap.find(resName);
        values.add(new Value<T>(xmlContext.getQualifiers(), value));
        Collections.sort(values);
    }

    public T get(ResName resName, String qualifiers) {
        Value<T> value = this.getValue(resName, qualifiers);
        return (T)(value == null ? null : ((Value)value).value);
    }

    public Value<T> getValue(ResName resName, String qualifiers) {
        List<Value<T>> values = this.valuesMap.find(this.maybeOverride(resName));
        return values != null ? ResBundle.pick(values, qualifiers) : null;
    }

    public static <T> Value<T> pick(List<Value<T>> values, String qualifiersStr) {
        Qualifiers qualifiers;
        int count = values.size();
        if (count == 0) {
            return null;
        }
        Qualifiers toMatch = Qualifiers.parse(qualifiersStr);
        Qualifiers bestMatchQualifiers = null;
        Value<Object> bestMatch = null;
        ArrayList<Value<T>> passesRequirements = new ArrayList<Value<T>>();
        for (Value<Object> value : values) {
            qualifiers = Qualifiers.parse(((Value)value).qualifiers);
            if (!qualifiers.passesRequirements(toMatch)) continue;
            passesRequirements.add(value);
        }
        for (Value<Object> value : passesRequirements) {
            qualifiers = Qualifiers.parse(((Value)value).qualifiers);
            if (!qualifiers.matches(toMatch) || bestMatchQualifiers != null && !qualifiers.isBetterThan(bestMatchQualifiers, toMatch)) continue;
            bestMatchQualifiers = qualifiers;
            bestMatch = value;
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        if (!passesRequirements.isEmpty()) {
            return (Value)passesRequirements.get(0);
        }
        return null;
    }

    public int size() {
        return this.valuesMap.size() + this.valuesArrayMap.size();
    }

    public void makeImmutable() {
        this.valuesMap.makeImmutable();
        this.valuesArrayMap.makeImmutable();
    }

    public void overrideNamespace(String overrideNamespace) {
        this.overrideNamespace = overrideNamespace;
        if (this.size() > 0) {
            throw new RuntimeException();
        }
    }

    String maybeOverride(String namespace) {
        return this.overrideNamespace == null ? namespace : this.overrideNamespace;
    }

    ResName maybeOverride(ResName resName) {
        return this.overrideNamespace == null ? resName : new ResName(this.overrideNamespace, resName.type, resName.name);
    }

    public void mergeLibraryStyle(ResBundle<T> fromResBundle, String packageName) {
        ((ResMap)this.valuesMap).merge(packageName, (ResMap)fromResBundle.valuesMap);
        ((ResMap)this.valuesArrayMap).merge(packageName, (ResMap)fromResBundle.valuesArrayMap);
    }

    public void receive(ResourceLoader.Visitor visitor) {
        for (final Map.Entry entry : ((ResMap)this.valuesMap).map.entrySet()) {
            visitor.visit((ResName)entry.getKey(), new AbstractList<T>(){
                List<Value<T>> value;

                @Override
                public T get(int index) {
                    if (this.value == null) {
                        this.value = (List)entry.getValue();
                    }
                    return this.value.get(index).getValue();
                }

                @Override
                public int size() {
                    if (this.value == null) {
                        this.value = (List)entry.getValue();
                    }
                    return this.value.size();
                }
            });
        }
    }

    private static class ResMap<T> {
        private final Map<ResName, List<Value<T>>> map = new HashMap<ResName, List<Value<T>>>();
        private boolean immutable;

        private ResMap() {
        }

        public List<Value<T>> find(ResName resName) {
            List<Value<T>> values = this.map.get(resName);
            if (values == null) {
                values = new ArrayList<Value<T>>();
                this.map.put(resName, values);
            }
            return values;
        }

        private void merge(String packageName, ResMap<T> sourceMap) {
            if (this.immutable) {
                throw new IllegalStateException("immutable!");
            }
            for (Map.Entry<ResName, List<Value<T>>> entry : sourceMap.map.entrySet()) {
                ResName resName = entry.getKey().withPackageName(packageName);
                this.find(resName).addAll((Collection)entry.getValue());
            }
        }

        public int size() {
            return this.map.size();
        }

        public void makeImmutable() {
            this.immutable = true;
        }
    }

    public static class Value<T>
    implements Comparable<Value<T>> {
        private final String qualifiers;
        private final T value;

        Value(String qualifiers, T value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.qualifiers = qualifiers == null ? "--" : "-" + qualifiers + "-";
            this.value = value;
        }

        public String getQualifiers() {
            return this.qualifiers;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Value<T> o) {
            return this.qualifiers.compareTo(o.qualifiers);
        }

        public String toString() {
            return "Value{qualifiers='" + this.qualifiers + '\'' + ", value=" + this.value + '}';
        }
    }
}

