/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Qualifiers {
    private static final Pattern SCREEN_WIDTH_PATTERN = Pattern.compile("^w([0-9]+)dp");
    private static final Pattern SMALLEST_SCREEN_WIDTH_PATTERN = Pattern.compile("^sw([0-9]+)dp");
    private static final Pattern VERSION_QUALIFIER_PATTERN = Pattern.compile("(v)([0-9]+)$");
    private static final Pattern SIZE_QUALIFIER_PATTERN = Pattern.compile("(s?[wh])([0-9]+)dp");
    private static final int ORDER_VERSION = 0;
    private static final List<String> INT_QUALIFIERS = Arrays.asList("v", "h", "w", "sh", "sw");
    private static final int TOTAL_ORDER_COUNT = INT_QUALIFIERS.size();
    private static final Map<String, Qualifiers> sQualifiersCache = new HashMap<String, Qualifiers>();
    private final int[] mWeights = new int[TOTAL_ORDER_COUNT];
    private final List<String> mDefaults = new ArrayList<String>();

    public boolean matches(Qualifiers other) {
        if (!this.passesRequirements(other)) {
            return false;
        }
        return other.mDefaults.containsAll(this.mDefaults);
    }

    public boolean passesRequirements(Qualifiers other) {
        for (int i = 0; i < TOTAL_ORDER_COUNT; ++i) {
            if (other.mWeights[i] == -1 || this.mWeights[i] == -1 || other.mWeights[i] >= this.mWeights[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isBetterThan(Qualifiers other, Qualifiers context) {
        for (String qualifier : context.mDefaults) {
            if (!(other.mDefaults.contains(qualifier) ^ this.mDefaults.contains(qualifier))) continue;
            return this.mDefaults.contains(qualifier);
        }
        for (int i = TOTAL_ORDER_COUNT - 1; i > 0; --i) {
            if (other.mWeights[i] == this.mWeights[i]) continue;
            return this.mWeights[i] > other.mWeights[i];
        }
        if (context.mWeights[0] != -1 && other.mWeights[0] != this.mWeights[0]) {
            return this.mWeights[0] > other.mWeights[0];
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Qualifiers parse(String qualifiersStr) {
        Map<String, Qualifiers> map = sQualifiersCache;
        synchronized (map) {
            Qualifiers result = sQualifiersCache.get(qualifiersStr);
            if (result != null) {
                return result;
            }
            StringTokenizer st = new StringTokenizer(qualifiersStr, "-");
            result = new Qualifiers();
            result.mWeights[0] = -1;
            while (st.hasMoreTokens()) {
                String qualifier = st.nextToken();
                if (qualifier.isEmpty()) continue;
                Matcher m = VERSION_QUALIFIER_PATTERN.matcher(qualifier);
                if (!m.find() && !(m = SIZE_QUALIFIER_PATTERN.matcher(qualifier)).find()) {
                    m = null;
                }
                if (m != null) {
                    int order = INT_QUALIFIERS.indexOf(m.group(1));
                    if (order == 0 && result.mWeights[0] != -1) {
                        throw new IllegalStateException("A resource file was found that had two API level qualifiers: " + qualifiersStr);
                    }
                    result.mWeights[order] = Integer.parseInt(m.group(2));
                    continue;
                }
                result.mDefaults.add(qualifier);
            }
            sQualifiersCache.put(qualifiersStr, result);
            return result;
        }
    }

    public static int getPlatformVersion(String qualifiers) {
        Matcher m = VERSION_QUALIFIER_PATTERN.matcher(qualifiers);
        if (m.find()) {
            return Integer.parseInt(m.group(2));
        }
        return -1;
    }

    public static int getSmallestScreenWidth(String qualifiers) {
        for (String qualifier : qualifiers.split("-")) {
            Matcher matcher = SMALLEST_SCREEN_WIDTH_PATTERN.matcher(qualifier);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    public static String addPlatformVersion(String qualifiers, int apiLevel) {
        int versionQualifierApiLevel = Qualifiers.getPlatformVersion(qualifiers);
        if (versionQualifierApiLevel == -1) {
            if (qualifiers.length() > 0) {
                qualifiers = qualifiers + "-";
            }
            qualifiers = qualifiers + "v" + apiLevel;
        }
        return qualifiers;
    }

    public static String addSmallestScreenWidth(String qualifiers, int smallestScreenWidth) {
        int qualifiersSmallestScreenWidth = Qualifiers.getSmallestScreenWidth(qualifiers);
        if (qualifiersSmallestScreenWidth == -1) {
            if (qualifiers.length() > 0) {
                qualifiers = qualifiers + "-";
            }
            qualifiers = qualifiers + "sw" + smallestScreenWidth + "dp";
        }
        return qualifiers;
    }

    public static int getScreenWidth(String qualifiers) {
        for (String qualifier : qualifiers.split("-")) {
            Matcher matcher = SCREEN_WIDTH_PATTERN.matcher(qualifier);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    public static String addScreenWidth(String qualifiers, int screenWidth) {
        int qualifiersScreenWidth = Qualifiers.getScreenWidth(qualifiers);
        if (qualifiersScreenWidth == -1) {
            if (qualifiers.length() > 0) {
                qualifiers = qualifiers + "-";
            }
            qualifiers = qualifiers + "w" + screenWidth + "dp";
        }
        return qualifiers;
    }
}

